/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.JsonCodec;
import org.onosproject.mapping.MappingEntry;
import org.onosproject.mapping.MappingKey;
import org.onosproject.mapping.MappingTreatment;
import org.onosproject.mapping.MappingValue;
import org.onosproject.mapping.actions.MappingAction;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.mapping.codec.MappingActionCodec;
import org.onosproject.mapping.codec.MappingAddressCodec;
import org.onosproject.mapping.codec.MappingEntryCodec;
import org.onosproject.mapping.codec.MappingInstructionCodec;
import org.onosproject.mapping.codec.MappingKeyCodec;
import org.onosproject.mapping.codec.MappingTreatmentCodec;
import org.onosproject.mapping.codec.MappingValueCodec;
import org.onosproject.mapping.instructions.MappingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class MappingCodecRegistrator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    public CodecService codecService;

    @Activate
    public void activate() {
        this.codecService.registerCodec(MappingAddress.class, (JsonCodec)new MappingAddressCodec());
        this.codecService.registerCodec(MappingInstruction.class, (JsonCodec)new MappingInstructionCodec());
        this.codecService.registerCodec(MappingAction.class, (JsonCodec)new MappingActionCodec());
        this.codecService.registerCodec(MappingTreatment.class, (JsonCodec)new MappingTreatmentCodec());
        this.codecService.registerCodec(MappingKey.class, (JsonCodec)new MappingKeyCodec());
        this.codecService.registerCodec(MappingValue.class, (JsonCodec)new MappingValueCodec());
        this.codecService.registerCodec(MappingEntry.class, (JsonCodec)new MappingEntryCodec());
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.codecService.unregisterCodec(MappingAddress.class);
        this.codecService.unregisterCodec(MappingInstruction.class);
        this.codecService.unregisterCodec(MappingAction.class);
        this.codecService.unregisterCodec(MappingTreatment.class);
        this.codecService.unregisterCodec(MappingKey.class);
        this.codecService.unregisterCodec(MappingValue.class);
        this.codecService.unregisterCodec(MappingEntry.class);
        this.log.info("Stopped");
    }

    protected void bindCodecService(CodecService codecService) {
        this.codecService = codecService;
    }

    protected void unbindCodecService(CodecService codecService) {
        if (this.codecService == codecService) {
            this.codecService = null;
        }
    }
}

