/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.onosproject.mapping.MappingTreatment;
import org.onosproject.mapping.MappingValue;
import org.onosproject.mapping.actions.MappingAction;
import org.onosproject.mapping.actions.MappingActions;

public final class DefaultMappingValue
implements MappingValue {
    private final MappingAction action;
    private final List<MappingTreatment> treatments;

    private DefaultMappingValue(MappingAction action, List<MappingTreatment> treatments) {
        this.action = action;
        this.treatments = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(treatments)));
    }

    @Override
    public MappingAction action() {
        return this.action;
    }

    @Override
    public List<MappingTreatment> treatments() {
        return ImmutableList.copyOf(this.treatments);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.treatments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultMappingValue) {
            DefaultMappingValue that = (DefaultMappingValue)obj;
            return Objects.equals(this.action, that.action) && Objects.equals(this.treatments, that.treatments);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("action", (Object)this.action).add("treatments", this.treatments).toString();
    }

    public static MappingValue.Builder builder() {
        return new Builder();
    }

    public static MappingValue.Builder builder(MappingValue value) {
        return new Builder(value);
    }

    public static final class Builder
    implements MappingValue.Builder {
        private MappingAction action;
        private List<MappingTreatment> treatments = Lists.newArrayList();

        private Builder() {
        }

        private Builder(MappingValue value) {
            value.treatments().forEach(t -> this.treatments.add((MappingTreatment)t));
            this.action = value.action();
        }

        @Override
        public Builder withAction(MappingAction action) {
            this.action = action;
            return this;
        }

        @Override
        public Builder add(MappingTreatment treatment) {
            this.treatments.add(treatment);
            return this;
        }

        @Override
        public MappingValue build() {
            if (this.action == null) {
                this.action = MappingActions.noAction();
            }
            return new DefaultMappingValue(this.action, this.treatments);
        }
    }
}

