/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.onosproject.mapping.MappingTreatment;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.mapping.instructions.MappingInstruction;
import org.onosproject.mapping.instructions.MappingInstructions;
import org.onosproject.mapping.instructions.MulticastMappingInstruction;
import org.onosproject.mapping.instructions.UnicastMappingInstruction;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.instructions.ExtensionTreatment;

public final class DefaultMappingTreatment
implements MappingTreatment {
    private final List<MappingInstruction> instructions;
    private final MappingAddress address;

    private DefaultMappingTreatment(MappingAddress address, List<MappingInstruction> instructions) {
        this.address = address;
        this.instructions = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(instructions)));
    }

    @Override
    public MappingAddress address() {
        return this.address;
    }

    @Override
    public List<MappingInstruction> instructions() {
        return ImmutableList.copyOf(this.instructions);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.instructions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultMappingTreatment) {
            DefaultMappingTreatment that = (DefaultMappingTreatment)obj;
            return Objects.equals(this.address, that.address) && Objects.equals(this.instructions, that.instructions);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("address", (Object)this.address).add("mapping instructions", this.instructions).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MappingTreatment treatment) {
        return new Builder(treatment);
    }

    public static final class Builder
    implements MappingTreatment.Builder {
        private List<MappingInstruction> instructions = Lists.newArrayList();
        private MappingAddress address;
        private Map<UnicastMappingInstruction.UnicastType, Integer> unicastTypeMap = Maps.newConcurrentMap();
        private Map<MulticastMappingInstruction.MulticastType, Integer> multicastTypeMap = Maps.newConcurrentMap();

        private Builder() {
            this.initTypeMap();
        }

        private Builder(MappingTreatment treatment) {
            treatment.instructions().forEach(i -> this.instructions.add((MappingInstruction)i));
            this.address = treatment.address();
            this.initTypeMap();
        }

        private void initTypeMap() {
            this.unicastTypeMap.put(UnicastMappingInstruction.UnicastType.WEIGHT, 0);
            this.unicastTypeMap.put(UnicastMappingInstruction.UnicastType.PRIORITY, 0);
            this.multicastTypeMap.put(MulticastMappingInstruction.MulticastType.WEIGHT, 0);
            this.multicastTypeMap.put(MulticastMappingInstruction.MulticastType.PRIORITY, 0);
        }

        @Override
        public Builder withAddress(MappingAddress address) {
            this.address = address;
            return this;
        }

        @Override
        public Builder add(MappingInstruction instruction) {
            switch (instruction.type()) {
                case UNICAST: {
                    this.unicastTypeMap.compute(((UnicastMappingInstruction)instruction).subtype(), (k, v) -> v + 1);
                    this.instructions.add(instruction);
                    break;
                }
                case MULTICAST: {
                    this.multicastTypeMap.compute(((MulticastMappingInstruction)instruction).subtype(), (k, v) -> v + 1);
                    this.instructions.add(instruction);
                    break;
                }
                case EXTENSION: {
                    this.instructions.add(instruction);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mapping instruction type: " + (Object)((Object)instruction.type()));
                }
            }
            return this;
        }

        @Override
        public Builder setUnicastWeight(int weight) {
            return this.add(MappingInstructions.unicastWeight(weight));
        }

        @Override
        public Builder setUnicastPriority(int priority) {
            return this.add(MappingInstructions.unicastPriority(priority));
        }

        @Override
        public Builder setMulticastWeight(int weight) {
            return this.add(MappingInstructions.multicastWeight(weight));
        }

        @Override
        public Builder setMulticastPriority(int priority) {
            return this.add(MappingInstructions.multicastPriority(priority));
        }

        @Override
        public Builder extension(ExtensionTreatment extension, DeviceId deviceId) {
            return this.add(MappingInstructions.extension(extension, deviceId));
        }

        @Override
        public MappingTreatment build() {
            this.unicastTypeMap.forEach((k, v) -> Preconditions.checkArgument((v <= 1 ? 1 : 0) != 0, (Object)("Should not specify more than one " + k.toString())));
            this.multicastTypeMap.forEach((k, v) -> Preconditions.checkArgument((v <= 1 ? 1 : 0) != 0, (Object)("Should not specify more than one " + k.toString())));
            return new DefaultMappingTreatment(this.address, this.instructions);
        }
    }
}

