/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.mapping.MappingKey;
import org.onosproject.mapping.addresses.MappingAddress;

public final class DefaultMappingKey
implements MappingKey {
    private final MappingAddress address;

    private DefaultMappingKey(MappingAddress address) {
        this.address = address;
    }

    @Override
    public MappingAddress address() {
        return this.address;
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultMappingKey) {
            DefaultMappingKey that = (DefaultMappingKey)obj;
            return Objects.equals(this.address, that.address);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("address", (Object)this.address).toString();
    }

    public static MappingKey.Builder builder() {
        return new Builder();
    }

    public static MappingKey.Builder builder(MappingKey key) {
        return new Builder(key);
    }

    public static final class Builder
    implements MappingKey.Builder {
        private MappingAddress address;

        private Builder() {
        }

        private Builder(MappingKey key) {
            this.address = key.address();
        }

        @Override
        public MappingKey.Builder withAddress(MappingAddress address) {
            this.address = address;
            return this;
        }

        @Override
        public MappingKey build() {
            return new DefaultMappingKey(this.address);
        }
    }
}

