/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.core.ApplicationId;
import org.onosproject.mapping.DefaultMappingKey;
import org.onosproject.mapping.DefaultMappingValue;
import org.onosproject.mapping.Mapping;
import org.onosproject.mapping.MappingId;
import org.onosproject.mapping.MappingKey;
import org.onosproject.mapping.MappingValue;
import org.onosproject.net.DeviceId;

public class DefaultMapping
implements Mapping {
    private final DeviceId deviceId;
    private final MappingKey key;
    private final MappingValue value;
    private final MappingId id;
    private final Short appId;

    public DefaultMapping(Mapping mapping) {
        this.deviceId = mapping.deviceId();
        this.key = mapping.key();
        this.value = mapping.value();
        this.appId = mapping.appId();
        this.id = mapping.id();
    }

    public DefaultMapping(DeviceId deviceId, MappingKey key, MappingValue value, MappingId id) {
        this.deviceId = deviceId;
        this.key = key;
        this.value = value;
        this.appId = (short)(id.value() >>> 48);
        this.id = id;
    }

    @Override
    public MappingId id() {
        return this.id;
    }

    @Override
    public short appId() {
        return this.appId;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public MappingKey key() {
        return this.key;
    }

    @Override
    public MappingValue value() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deviceId, this.key, this.value, this.id});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultMapping) {
            DefaultMapping that = (DefaultMapping)obj;
            return Objects.equals(this.deviceId, that.deviceId) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals((Object)this.id, (Object)that.id);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)Long.toHexString(this.id.value())).add("deviceId", (Object)this.deviceId).add("key", (Object)this.key).add("value", (Object)this.value).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements Mapping.Builder {
        private MappingId id;
        private ApplicationId appId;
        private DeviceId deviceId;
        private MappingKey key = DefaultMappingKey.builder().build();
        private MappingValue value = DefaultMappingValue.builder().build();

        @Override
        public Mapping.Builder withId(long id) {
            this.id = MappingId.valueOf(id);
            return this;
        }

        @Override
        public Mapping.Builder fromApp(ApplicationId appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public Mapping.Builder forDevice(DeviceId deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public Mapping.Builder withKey(MappingKey key) {
            this.key = key;
            return this;
        }

        @Override
        public Mapping.Builder withValue(MappingValue value) {
            this.value = value;
            return this;
        }

        @Override
        public Mapping build() {
            Preconditions.checkArgument((this.id != null || this.appId != null ? 1 : 0) != 0, (Object)"Either an application id or a mapping id must be supplied");
            Preconditions.checkNotNull((Object)this.key, (Object)"Mapping key cannot be null");
            Preconditions.checkNotNull((Object)this.deviceId, (Object)"Must refer to a device");
            return new DefaultMapping(this.deviceId, this.key, this.value, this.id);
        }
    }
}

