/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.sfc.installer.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.NshContextHeader;
import org.onosproject.net.NshServiceIndex;
import org.onosproject.net.NshServicePathId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.BridgeConfig;
import org.onosproject.net.behaviour.ExtensionSelectorResolver;
import org.onosproject.net.behaviour.ExtensionTreatmentResolver;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.ExtensionSelectorType;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.host.HostService;
import org.onosproject.sfc.installer.SfcFlowRuleInstallerService;
import org.onosproject.vtnrsc.FiveTuple;
import org.onosproject.vtnrsc.FlowClassifier;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.PortPairGroup;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.SegmentationId;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.flowclassifier.FlowClassifierService;
import org.onosproject.vtnrsc.portpair.PortPairService;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupService;
import org.onosproject.vtnrsc.service.VtnRscService;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfcFlowRuleInstallerImpl
implements SfcFlowRuleInstallerService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected VirtualPortService virtualPortService;
    protected VtnRscService vtnRscService;
    protected PortPairService portPairService;
    protected PortPairGroupService portPairGroupService;
    protected FlowClassifierService flowClassifierService;
    protected DriverService driverService;
    protected DeviceService deviceService;
    protected HostService hostService;
    protected TenantNetworkService tenantNetworkService;
    protected FlowObjectiveService flowObjectiveService;
    protected ApplicationId appId;
    private static final String PORT_CHAIN_NOT_NULL = "Port-Chain cannot be null";
    private static final int FLOW_CLASSIFIER_PRIORITY = 51000;
    private static final int DEFAULT_FORWARDER_PRIORITY = 55000;
    private static final int ENCAP_OUTPUT_PRIORITY = 100;
    private static final int TUNNEL_SEND_PRIORITY = 200;
    private static final String SWITCH_CHANNEL_ID = "channelId";
    private static final int ENCAP_OUTPUT_TABLE = 4;
    private static final int TUNNEL_SEND_TABLE = 7;
    private static final short ENCAP_ETH_TYPE = -30385;
    private static final String DEFAULT_IP = "0.0.0.0";
    private static final String VXLANPORT_HEAD = "vxlan-0.0.0.0";
    private short nshSi;
    List<DeviceId> classifierList;
    List<DeviceId> forwarderList;

    public SfcFlowRuleInstallerImpl() {
    }

    public SfcFlowRuleInstallerImpl(ApplicationId appId) {
        this.appId = (ApplicationId)Preconditions.checkNotNull((Object)appId, (Object)"ApplicationId can not be null");
        DefaultServiceDirectory serviceDirectory = new DefaultServiceDirectory();
        this.flowObjectiveService = (FlowObjectiveService)serviceDirectory.get(FlowObjectiveService.class);
        this.driverService = (DriverService)serviceDirectory.get(DriverService.class);
        this.deviceService = (DeviceService)serviceDirectory.get(DeviceService.class);
        this.hostService = (HostService)serviceDirectory.get(HostService.class);
        this.virtualPortService = (VirtualPortService)serviceDirectory.get(VirtualPortService.class);
        this.vtnRscService = (VtnRscService)serviceDirectory.get(VtnRscService.class);
        this.portPairService = (PortPairService)serviceDirectory.get(PortPairService.class);
        this.portPairGroupService = (PortPairGroupService)serviceDirectory.get(PortPairGroupService.class);
        this.flowClassifierService = (FlowClassifierService)serviceDirectory.get(FlowClassifierService.class);
        this.tenantNetworkService = (TenantNetworkService)serviceDirectory.get(TenantNetworkService.class);
        this.nshSi = (short)255;
    }

    @Override
    public ConnectPoint installFlowClassifier(PortChain portChain, NshServicePathId nshSpiId) {
        Preconditions.checkNotNull((Object)portChain, (Object)PORT_CHAIN_NOT_NULL);
        List llPortPairGroupIdList = portChain.portPairGroups();
        ListIterator portPairGroupIdListIterator = llPortPairGroupIdList.listIterator();
        PortPairGroupId portPairGroupId = (PortPairGroupId)portPairGroupIdListIterator.next();
        PortPairGroup portPairGroup = this.portPairGroupService.getPortPairGroup(portPairGroupId);
        List llPortPairIdList = portPairGroup.portPairs();
        ListIterator portPairListIterator = llPortPairIdList.listIterator();
        PortPairId portPairId = (PortPairId)portPairListIterator.next();
        PortPair portPair = this.portPairService.getPortPair(portPairId);
        return this.installSfcClassifierRules(portChain, portPair, nshSpiId, null, Objective.Operation.ADD);
    }

    @Override
    public ConnectPoint unInstallFlowClassifier(PortChain portChain, NshServicePathId nshSpiId) {
        Preconditions.checkNotNull((Object)portChain, (Object)PORT_CHAIN_NOT_NULL);
        List llPortPairGroupIdList = portChain.portPairGroups();
        ListIterator portPairGroupIdListIterator = llPortPairGroupIdList.listIterator();
        PortPairGroupId portPairGroupId = (PortPairGroupId)portPairGroupIdListIterator.next();
        PortPairGroup portPairGroup = this.portPairGroupService.getPortPairGroup(portPairGroupId);
        List llPortPairIdList = portPairGroup.portPairs();
        ListIterator portPairListIterator = llPortPairIdList.listIterator();
        PortPairId portPairId = (PortPairId)portPairListIterator.next();
        PortPair portPair = this.portPairService.getPortPair(portPairId);
        return this.installSfcClassifierRules(portChain, portPair, nshSpiId, null, Objective.Operation.REMOVE);
    }

    @Override
    public ConnectPoint installLoadBalancedFlowRules(PortChain portChain, FiveTuple fiveTuple, NshServicePathId nshSpiId) {
        Preconditions.checkNotNull((Object)portChain, (Object)PORT_CHAIN_NOT_NULL);
        return this.installSfcFlowRules(portChain, fiveTuple, nshSpiId, Objective.Operation.ADD);
    }

    @Override
    public ConnectPoint unInstallLoadBalancedFlowRules(PortChain portChain, FiveTuple fiveTuple, NshServicePathId nshSpiId) {
        Preconditions.checkNotNull((Object)portChain, (Object)PORT_CHAIN_NOT_NULL);
        return this.installSfcFlowRules(portChain, fiveTuple, nshSpiId, Objective.Operation.REMOVE);
    }

    @Override
    public ConnectPoint unInstallLoadBalancedClassifierRules(PortChain portChain, FiveTuple fiveTuple, NshServicePathId nshSpiId) {
        Preconditions.checkNotNull((Object)portChain, (Object)PORT_CHAIN_NOT_NULL);
        List portPairs = portChain.getLoadBalancePath(fiveTuple);
        ListIterator portPairListIterator = portPairs.listIterator();
        PortPairId portPairId = (PortPairId)portPairListIterator.next();
        PortPair portPair = this.portPairService.getPortPair(portPairId);
        return this.installSfcClassifierRules(portChain, portPair, nshSpiId, fiveTuple, Objective.Operation.REMOVE);
    }

    public ConnectPoint installSfcFlowRules(PortChain portChain, FiveTuple fiveTuple, NshServicePathId nshSpiId, Objective.Operation type) {
        Preconditions.checkNotNull((Object)portChain, (Object)PORT_CHAIN_NOT_NULL);
        this.classifierList = Lists.newArrayList();
        this.forwarderList = Lists.newArrayList();
        List portPairs = portChain.getLoadBalancePath(fiveTuple);
        ListIterator portPairListIterator = portPairs.listIterator();
        PortPairId portPairId = (PortPairId)portPairListIterator.next();
        PortPair currentPortPair = this.portPairService.getPortPair(portPairId);
        ConnectPoint connectPoint = this.installSfcClassifierRules(portChain, currentPortPair, nshSpiId, fiveTuple, type);
        this.log.info("Installing encap and output for first port pair");
        this.installSfcEncapOutputRule(currentPortPair, nshSpiId, type);
        while (portPairListIterator.hasNext()) {
            portPairId = (PortPairId)portPairListIterator.next();
            PortPair nextPortPair = this.portPairService.getPortPair(portPairId);
            this.installSfcForwardRule(currentPortPair, nextPortPair, nshSpiId, type);
            this.installSfcEncapOutputRule(nextPortPair, nshSpiId, type);
            currentPortPair = nextPortPair;
        }
        this.installSfcEndRule(currentPortPair, nshSpiId, type);
        if (type.equals((Object)Objective.Operation.ADD)) {
            portChain.addSfcClassifiers(portChain.getLoadBalanceId(fiveTuple), this.classifierList);
            portChain.addSfcForwarders(portChain.getLoadBalanceId(fiveTuple), this.forwarderList);
        } else {
            portChain.removeSfcClassifiers(portChain.getLoadBalanceId(fiveTuple), this.classifierList);
            portChain.removeSfcForwarders(portChain.getLoadBalanceId(fiveTuple), this.forwarderList);
        }
        return connectPoint;
    }

    public void installSfcTunnelReceiveRule(DeviceId deviceId, NshServicePathId nshSpiId, Objective.Operation type) {
        DriverHandler handler = this.driverService.createHandler(deviceId, new String[0]);
        ExtensionSelectorResolver selectorResolver = (ExtensionSelectorResolver)handler.behaviour(ExtensionSelectorResolver.class);
        ExtensionSelector nshSpiSelector = selectorResolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SPI.type());
        ExtensionSelector nshSiSelector = selectorResolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SI.type());
        try {
            nshSpiSelector.setPropertyValue("nshSpi", (Object)nshSpiId);
        }
        catch (Exception e) {
            this.log.error("Failed to set extension selector to match Nsh Spi Id for end rule {}", (Object)e.getMessage());
        }
        try {
            nshSiSelector.setPropertyValue("nshSi", (Object)NshServiceIndex.of((short)this.nshSi));
        }
        catch (Exception e) {
            this.log.error("Failed to set extension selector to match Nsh Si Id for end rule {}", (Object)e.getMessage());
        }
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.extension(nshSpiSelector, deviceId);
        selector.extension(nshSiSelector, deviceId);
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(4));
        this.sendSfcRule(selector, treatment, deviceId, type, 55000);
    }

    public void installSfcTunnelSendRule(DeviceId deviceId, NshServicePathId nshSpiId, Objective.Operation type) {
        DriverHandler handler = this.driverService.createHandler(deviceId, new String[0]);
        ExtensionSelectorResolver selectorResolver = (ExtensionSelectorResolver)handler.behaviour(ExtensionSelectorResolver.class);
        ExtensionSelector nshSpiSelector = selectorResolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SPI.type());
        ExtensionSelector nshSiSelector = selectorResolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SI.type());
        ExtensionSelector encapEthTypeSelector = selectorResolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_ENCAP_ETH_TYPE.type());
        try {
            nshSpiSelector.setPropertyValue("nshSpi", (Object)nshSpiId);
        }
        catch (Exception e) {
            this.log.error("Failed to set extension selector to match Nsh Spi Id for end rule {}", (Object)e.getMessage());
        }
        try {
            nshSiSelector.setPropertyValue("nshSi", (Object)NshServiceIndex.of((short)this.nshSi));
        }
        catch (Exception e) {
            this.log.error("Failed to set extension selector to match Nsh Si Id for end rule {}", (Object)e.getMessage());
        }
        try {
            encapEthTypeSelector.setPropertyValue("encapEthType", (Object)-30385);
        }
        catch (Exception e) {
            this.log.error("Failed to set extension selector to match encapEthType {}", (Object)deviceId);
        }
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.extension(nshSpiSelector, deviceId);
        selector.extension(nshSiSelector, deviceId);
        ExtensionTreatmentResolver treatmentResolver = (ExtensionTreatmentResolver)handler.behaviour(ExtensionTreatmentResolver.class);
        ExtensionTreatment tunGpeNpTreatment = treatmentResolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_TUN_GPE_NP.type());
        try {
            tunGpeNpTreatment.setPropertyValue("tunGpeNp", (Object)4);
        }
        catch (Exception e) {
            this.log.error("Failed to get extension instruction to set tunGpeNp {}", (Object)deviceId);
        }
        ExtensionTreatment moveC1ToC1 = treatmentResolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C1_TO_C1.type());
        ExtensionTreatment moveC2ToC2 = treatmentResolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C2_TO_C2.type());
        ExtensionTreatment moveC3ToC3 = treatmentResolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C3_TO_C3.type());
        ExtensionTreatment moveC4ToC4 = treatmentResolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C4_TO_C4.type());
        ExtensionTreatment moveTunIpv4DstToTunIpv4Dst = treatmentResolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_TUN_IPV4_DST_TO_TUN_IPV4_DST.type());
        ExtensionTreatment moveTunIdToTunId = treatmentResolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_TUN_ID_TO_TUN_ID.type());
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.extension(tunGpeNpTreatment, deviceId);
        treatment.extension(moveC1ToC1, deviceId);
        treatment.extension(moveC2ToC2, deviceId);
        treatment.extension(moveC3ToC3, deviceId);
        treatment.extension(moveC4ToC4, deviceId);
        treatment.extension(moveTunIpv4DstToTunIpv4Dst, deviceId);
        treatment.extension(moveTunIdToTunId, deviceId);
        Iterable devices = this.deviceService.getAvailableDevices();
        DeviceId localControllerId = this.getControllerId(this.deviceService.getDevice(deviceId), devices);
        DriverHandler controllerHandler = this.driverService.createHandler(localControllerId, new String[0]);
        BridgeConfig bridgeConfig = (BridgeConfig)controllerHandler.behaviour(BridgeConfig.class);
        Set ports = bridgeConfig.getPortNumbers();
        String tunnelName = VXLANPORT_HEAD;
        ports.stream().filter(p -> p.name().equalsIgnoreCase(tunnelName)).forEach(p -> {
            treatment.setOutput(p);
            this.sendSfcRule(selector, treatment, deviceId, type, 200);
        });
    }

    public void installSfcEndRule(PortPair portPair, NshServicePathId nshSpiId, Objective.Operation type) {
        DeviceId deviceId = this.vtnRscService.getSfToSffMaping(VirtualPortId.portId((String)portPair.egress()));
        MacAddress srcMacAddress = this.virtualPortService.getPort(VirtualPortId.portId((String)portPair.egress())).macAddress();
        Host host = this.hostService.getHost(HostId.hostId((MacAddress)srcMacAddress));
        PortNumber port = host.location().port();
        DriverHandler handler = this.driverService.createHandler(deviceId, new String[0]);
        ExtensionSelectorResolver selectorResolver = (ExtensionSelectorResolver)handler.behaviour(ExtensionSelectorResolver.class);
        ExtensionSelector nshSpiSelector = selectorResolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SPI.type());
        ExtensionSelector nshSiSelector = selectorResolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SI.type());
        ExtensionSelector encapEthTypeSelector = selectorResolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_ENCAP_ETH_TYPE.type());
        try {
            nshSpiSelector.setPropertyValue("nshSpi", (Object)nshSpiId);
        }
        catch (Exception e) {
            this.log.error("Failed to set extension selector to match Nsh Spi Id for end rule {}", (Object)e.getMessage());
        }
        this.nshSi = (short)(this.nshSi - 1);
        try {
            nshSiSelector.setPropertyValue("nshSi", (Object)NshServiceIndex.of((short)this.nshSi));
        }
        catch (Exception e) {
            this.log.error("Failed to set extension selector to match Nsh Si Id for end rule {}", (Object)e.getMessage());
        }
        try {
            encapEthTypeSelector.setPropertyValue("encapEthType", (Object)-30385);
        }
        catch (Exception e) {
            this.log.error("Failed to set extension selector to match encapEthType {}", (Object)deviceId);
        }
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.extension(encapEthTypeSelector, deviceId);
        selector.extension(nshSpiSelector, deviceId);
        selector.extension(nshSiSelector, deviceId);
        selector.matchInPort(port);
        ExtensionTreatmentResolver treatmentResolver = (ExtensionTreatmentResolver)handler.behaviour(ExtensionTreatmentResolver.class);
        ExtensionTreatment popNshTreatment = treatmentResolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_POP_NSH.type());
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.extension(popNshTreatment, deviceId);
        VirtualPort virtualPort = this.virtualPortService.getPort(VirtualPortId.portId((String)portPair.ingress()));
        SegmentationId segmentationId = this.tenantNetworkService.getNetwork(virtualPort.networkId()).segmentationId();
        treatment.add((Instruction)Instructions.modTunnelId((long)Long.parseLong(segmentationId.toString())));
        ExtensionTreatment resubmitTableTreatment = treatmentResolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_RESUBMIT_TABLE.type());
        PortNumber vxlanPortNumber = this.getVxlanPortNumber(deviceId);
        try {
            resubmitTableTreatment.setPropertyValue("inPort", (Object)vxlanPortNumber);
        }
        catch (Exception e) {
            this.log.error("Failed to set extension treatment for resubmit table in port {}", (Object)deviceId);
        }
        try {
            resubmitTableTreatment.setPropertyValue("table", (Object)0);
        }
        catch (Exception e) {
            this.log.error("Failed to set extension treatment for resubmit table {}", (Object)deviceId);
        }
        treatment.extension(resubmitTableTreatment, deviceId);
        this.sendSfcRule(selector, treatment, deviceId, type, 55000);
    }

    public void installSfcForwardRule(PortPair portPair, PortPair nextPortPair, NshServicePathId nshSpiId, Objective.Operation type) {
        DeviceId deviceId = this.vtnRscService.getSfToSffMaping(VirtualPortId.portId((String)portPair.egress()));
        MacAddress srcMacAddress = this.virtualPortService.getPort(VirtualPortId.portId((String)portPair.egress())).macAddress();
        Host host = this.hostService.getHost(HostId.hostId((MacAddress)srcMacAddress));
        PortNumber port = host.location().port();
        DriverHandler handler = this.driverService.createHandler(deviceId, new String[0]);
        ExtensionSelectorResolver resolver = (ExtensionSelectorResolver)handler.behaviour(ExtensionSelectorResolver.class);
        ExtensionSelector nshSpiSelector = resolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SPI.type());
        ExtensionSelector nshSiSelector = resolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SI.type());
        try {
            nshSpiSelector.setPropertyValue("nshSpi", (Object)nshSpiId);
        }
        catch (Exception e) {
            this.log.error("Failed to set extension selector to match Nsh Spi Id for forward rule {}", (Object)e.getMessage());
        }
        this.nshSi = (short)(this.nshSi - 1);
        try {
            nshSiSelector.setPropertyValue("nshSi", (Object)NshServiceIndex.of((short)this.nshSi));
        }
        catch (Exception e) {
            this.log.error("Failed to set extension selector to match Nsh Si Id for forward rule {}", (Object)e.getMessage());
        }
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.extension(nshSpiSelector, deviceId);
        selector.extension(nshSiSelector, deviceId);
        selector.matchInPort(port);
        DeviceId nextDeviceId = this.vtnRscService.getSfToSffMaping(VirtualPortId.portId((String)nextPortPair.ingress()));
        if (deviceId.equals((Object)nextDeviceId)) {
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
            treatment.transition(Integer.valueOf(4));
            this.sendSfcRule(selector, treatment, deviceId, type, 55000);
        } else {
            ExtensionTreatmentResolver treatmentResolver = (ExtensionTreatmentResolver)handler.behaviour(ExtensionTreatmentResolver.class);
            ExtensionTreatment moveC2ToTunId = treatmentResolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C2_TO_TUN_ID.type());
            Device remoteDevice = this.deviceService.getDevice(nextDeviceId);
            String url = remoteDevice.annotations().value(SWITCH_CHANNEL_ID);
            String remoteControllerIp = url.substring(0, url.lastIndexOf(":"));
            if (remoteControllerIp == null) {
                this.log.error("Can't find remote controller of device: {}", (Object)nextDeviceId.toString());
                return;
            }
            ExtensionTreatment tunnelDsttreatment = treatmentResolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_TUNNEL_DST.type());
            try {
                tunnelDsttreatment.setPropertyValue("tunnelDst", (Object)Ip4Address.valueOf((String)remoteControllerIp));
            }
            catch (Exception e) {
                this.log.error("Failed to get extension instruction to set tunnel dst {}", (Object)deviceId);
            }
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
            treatment.extension(moveC2ToTunId, deviceId);
            treatment.extension(tunnelDsttreatment, deviceId);
            treatment.transition(Integer.valueOf(7));
            this.sendSfcRule(selector, treatment, deviceId, type, 55000);
            this.installSfcTunnelSendRule(deviceId, nshSpiId, type);
            this.installSfcTunnelReceiveRule(nextDeviceId, nshSpiId, type);
        }
    }

    public void installSfcEncapOutputRule(PortPair portPair, NshServicePathId nshSpiId, Objective.Operation type) {
        DeviceId deviceId = this.vtnRscService.getSfToSffMaping(VirtualPortId.portId((String)portPair.ingress()));
        MacAddress srcMacAddress = this.virtualPortService.getPort(VirtualPortId.portId((String)portPair.ingress())).macAddress();
        Host host = this.hostService.getHost(HostId.hostId((MacAddress)srcMacAddress));
        PortNumber port = host.location().port();
        DriverHandler handler = this.driverService.createHandler(deviceId, new String[0]);
        ExtensionSelectorResolver resolver = (ExtensionSelectorResolver)handler.behaviour(ExtensionSelectorResolver.class);
        ExtensionSelector nshSpiSelector = resolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SPI.type());
        ExtensionSelector nshSiSelector = resolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SI.type());
        ExtensionSelector nshEncapEthTypeSelector = resolver.getExtensionSelector(ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_ENCAP_ETH_TYPE.type());
        try {
            nshSpiSelector.setPropertyValue("nshSpi", (Object)nshSpiId);
        }
        catch (Exception e) {
            this.log.error("Failed to set extension selector to match Nsh Spi Id for encap rule {}", (Object)e.getMessage());
        }
        try {
            nshSiSelector.setPropertyValue("nshSi", (Object)NshServiceIndex.of((short)this.nshSi));
        }
        catch (Exception e) {
            this.log.error("Failed to set extension selector to match Nsh Si Id for encap rule {}", (Object)e.getMessage());
        }
        try {
            nshEncapEthTypeSelector.setPropertyValue("encapEthType", (Object)-30385);
        }
        catch (Exception e) {
            this.log.error("Failed to set extension selector to match Nsh Si Id {}", (Object)deviceId);
        }
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.extension(nshSpiSelector, deviceId);
        selector.extension(nshSiSelector, deviceId);
        ExtensionTreatmentResolver treatmentResolver = (ExtensionTreatmentResolver)handler.behaviour(ExtensionTreatmentResolver.class);
        ExtensionTreatment encapEthSrcTreatment = treatmentResolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_ENCAP_ETH_SRC.type());
        ExtensionTreatment encapEthDstTreatment = treatmentResolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_ENCAP_ETH_DST.type());
        try {
            encapEthDstTreatment.setPropertyValue("encapEthDst", (Object)srcMacAddress);
        }
        catch (Exception e) {
            this.log.error("Failed to set extension treatment to set encap eth dst {}", (Object)deviceId);
        }
        try {
            encapEthSrcTreatment.setPropertyValue("encapEthSrc", (Object)srcMacAddress);
        }
        catch (Exception e) {
            this.log.error("Failed to set extension treatment to set encap eth src {}", (Object)deviceId);
        }
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.extension(encapEthSrcTreatment, deviceId);
        treatment.extension(encapEthDstTreatment, deviceId);
        treatment.setOutput(port);
        this.sendSfcRule(selector, treatment, deviceId, type, 100);
        this.forwarderList.add(deviceId);
    }

    public ConnectPoint installSfcClassifierRules(PortChain portChain, PortPair portPair, NshServicePathId nshSpiId, FiveTuple fiveTuple, Objective.Operation type) {
        DeviceId deviceIdfromPortPair = this.vtnRscService.getSfToSffMaping(VirtualPortId.portId((String)portPair.ingress()));
        MacAddress srcMacAddress = this.virtualPortService.getPort(VirtualPortId.portId((String)portPair.ingress())).macAddress();
        VirtualPort virtualPort = this.virtualPortService.getPort(VirtualPortId.portId((String)portPair.ingress()));
        Host host = this.hostService.getHost(HostId.hostId((MacAddress)srcMacAddress));
        PortNumber port = host.location().port();
        DeviceId deviceId = deviceIdfromPortPair;
        List llFlowClassifierList = portChain.flowClassifiers();
        ListIterator flowClassifierListIterator = llFlowClassifierList.listIterator();
        while (flowClassifierListIterator.hasNext()) {
            TrafficTreatment.Builder treatment;
            FlowClassifierId flowclassifierId = (FlowClassifierId)flowClassifierListIterator.next();
            FlowClassifier flowClassifier = this.flowClassifierService.getFlowClassifier(flowclassifierId);
            if (flowClassifier.srcPort() != null && !flowClassifier.srcPort().portId().isEmpty()) {
                deviceId = this.vtnRscService.getSfToSffMaping(flowClassifier.srcPort());
            }
            TrafficSelector.Builder selector = this.packClassifierSelector(flowClassifier, fiveTuple);
            if (fiveTuple == null) {
                this.log.info("Downloading rule to send packet to controller");
                treatment = DefaultTrafficTreatment.builder();
                treatment.setOutput(PortNumber.CONTROLLER);
                this.sendSfcRule(selector, treatment, deviceId, type, 51000);
                continue;
            }
            if (deviceId != null && !deviceId.equals((Object)deviceIdfromPortPair)) {
                Device remoteDevice = this.deviceService.getDevice(deviceIdfromPortPair);
                String url = remoteDevice.annotations().value(SWITCH_CHANNEL_ID);
                String remoteControllerIp = url.substring(0, url.lastIndexOf(":"));
                if (remoteControllerIp == null) {
                    this.log.error("Can't find remote controller of device: {}", (Object)deviceIdfromPortPair.toString());
                    return null;
                }
                DriverHandler handler = this.driverService.createHandler(deviceId, new String[0]);
                ExtensionTreatmentResolver resolver = (ExtensionTreatmentResolver)handler.behaviour(ExtensionTreatmentResolver.class);
                ExtensionTreatment tunnelDsttreatment = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_TUNNEL_DST.type());
                try {
                    tunnelDsttreatment.setPropertyValue("tunnelDst", (Object)Ip4Address.valueOf((String)remoteControllerIp));
                }
                catch (Exception e) {
                    this.log.error("Failed to get extension instruction to set tunnel dst {}", (Object)deviceId);
                }
                TrafficTreatment.Builder treatment2 = this.packClassifierTreatment(deviceId, virtualPort, port, nshSpiId, flowClassifier);
                treatment2.extension(tunnelDsttreatment, deviceId);
                treatment2.transition(Integer.valueOf(7));
                this.sendSfcRule(selector, treatment2, deviceId, type, flowClassifier.priority());
                selector.matchInPort(PortNumber.CONTROLLER);
                this.sendSfcRule(selector, treatment2, deviceId, type, flowClassifier.priority());
                this.classifierList.add(deviceId);
                this.installSfcTunnelSendRule(deviceId, nshSpiId, type);
                this.installSfcTunnelReceiveRule(deviceIdfromPortPair, nshSpiId, type);
                continue;
            }
            treatment = this.packClassifierTreatment(deviceIdfromPortPair, virtualPort, port, nshSpiId, flowClassifier);
            treatment.transition(Integer.valueOf(4));
            this.sendSfcRule(selector, treatment, deviceIdfromPortPair, type, flowClassifier.priority());
            selector.matchInPort(PortNumber.CONTROLLER);
            this.sendSfcRule(selector, treatment, deviceId, type, flowClassifier.priority());
            this.classifierList.add(deviceIdfromPortPair);
        }
        return host.location();
    }

    public TrafficSelector.Builder packClassifierSelector(FlowClassifier flowClassifier, FiveTuple fiveTuple) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        if (flowClassifier.srcIpPrefix() != null && flowClassifier.srcIpPrefix().prefixLength() != 0) {
            selector.matchIPSrc(flowClassifier.srcIpPrefix());
        } else if (fiveTuple != null && fiveTuple.ipSrc() != null) {
            selector.matchIPSrc(IpPrefix.valueOf((IpAddress)fiveTuple.ipSrc(), (int)24));
        }
        if (flowClassifier.dstIpPrefix() != null && flowClassifier.dstIpPrefix().prefixLength() != 0) {
            selector.matchIPDst(flowClassifier.dstIpPrefix());
        } else if (fiveTuple != null && fiveTuple.ipDst() != null) {
            selector.matchIPDst(IpPrefix.valueOf((IpAddress)fiveTuple.ipDst(), (int)24));
        }
        if (flowClassifier.protocol() != null && !flowClassifier.protocol().isEmpty()) {
            if ("TCP".equalsIgnoreCase(flowClassifier.protocol())) {
                selector.add(Criteria.matchIPProtocol((short)6));
            } else if ("UDP".equalsIgnoreCase(flowClassifier.protocol())) {
                selector.add(Criteria.matchIPProtocol((short)17));
            } else if ("ICMP".equalsIgnoreCase(flowClassifier.protocol())) {
                selector.add(Criteria.matchIPProtocol((short)1));
            }
        } else if (fiveTuple != null && fiveTuple.protocol() != 0) {
            selector.add(Criteria.matchIPProtocol((short)fiveTuple.protocol()));
        }
        if (flowClassifier.etherType() != null && !flowClassifier.etherType().isEmpty() && ("IPv4".equals(flowClassifier.etherType()) || "IPv6".equals(flowClassifier.etherType()))) {
            if ("IPv4".equals(flowClassifier.etherType())) {
                selector.matchEthType(Ethernet.TYPE_IPV4);
            } else {
                selector.matchEthType(Ethernet.TYPE_IPV6);
            }
        }
        if (flowClassifier.srcPort() != null && !flowClassifier.srcPort().portId().isEmpty()) {
            VirtualPortId vPortId = VirtualPortId.portId((String)flowClassifier.srcPort().portId());
            MacAddress macAddress = this.virtualPortService.getPort(vPortId).macAddress();
            Host host = this.hostService.getHost(HostId.hostId((MacAddress)macAddress));
            selector.matchInPort(host.location().port());
        }
        if (fiveTuple != null && fiveTuple.protocol() == 6) {
            selector.matchTcpSrc(TpPort.tpPort((int)((int)fiveTuple.portSrc().toLong())));
            selector.matchTcpDst(TpPort.tpPort((int)((int)fiveTuple.portDst().toLong())));
        } else {
            LinkedList<TpPort> srcPortRange = new LinkedList<TpPort>();
            LinkedList<TpPort> dstPortRange = new LinkedList<TpPort>();
            if (flowClassifier.minSrcPortRange() != 0 && flowClassifier.maxSrcPortRange() != 0 && flowClassifier.minDstPortRange() != 0 && flowClassifier.maxDstPortRange() != 0) {
                int port;
                for (port = flowClassifier.minSrcPortRange(); port <= flowClassifier.maxSrcPortRange(); ++port) {
                    srcPortRange.add(TpPort.tpPort((int)port));
                }
                for (port = flowClassifier.minDstPortRange(); port <= flowClassifier.maxDstPortRange(); ++port) {
                    dstPortRange.add(TpPort.tpPort((int)port));
                }
            }
            for (TpPort inPort : srcPortRange) {
                selector.matchUdpSrc(inPort);
            }
            for (TpPort outPort : dstPortRange) {
                selector.matchUdpDst(outPort);
            }
        }
        return selector;
    }

    public TrafficTreatment.Builder packClassifierTreatment(DeviceId deviceId, VirtualPort virtualPort, PortNumber port, NshServicePathId nshSpi, FlowClassifier flowClassifier) {
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        SegmentationId segmentationId = this.tenantNetworkService.getNetwork(virtualPort.networkId()).segmentationId();
        treatmentBuilder.add((Instruction)Instructions.modTunnelId((long)Long.parseLong(segmentationId.toString())));
        DriverHandler handler = this.driverService.createHandler(deviceId, new String[0]);
        ExtensionTreatmentResolver resolver = (ExtensionTreatmentResolver)handler.behaviour(ExtensionTreatmentResolver.class);
        ExtensionTreatment nspIdTreatment = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_SPI.type());
        ExtensionTreatment nsiIdTreatment = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_SI.type());
        ExtensionTreatment pushNshTreatment = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_PUSH_NSH.type());
        ExtensionTreatment nshCh1Treatment = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH1.type());
        ExtensionTreatment nshCh2Treatment = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH2.type());
        ExtensionTreatment nshCh3Treatment = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH3.type());
        ExtensionTreatment nshCh4Treatment = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH4.type());
        ExtensionTreatment nshMdTypeTreatment = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_NSH_MDTYPE.type());
        ExtensionTreatment nshNpTreatment = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_NSH_NP.type());
        try {
            nshMdTypeTreatment.setPropertyValue("nshMdType", (Object)1);
        }
        catch (Exception e) {
            this.log.error("Failed to get extension instruction to set nshMdType {}", (Object)deviceId);
        }
        try {
            nshNpTreatment.setPropertyValue("nshNp", (Object)3);
        }
        catch (Exception e) {
            this.log.error("Failed to get extension instruction to set nshNp {}", (Object)deviceId);
        }
        try {
            nspIdTreatment.setPropertyValue("nshSpi", (Object)nshSpi);
        }
        catch (Exception e) {
            this.log.error("Failed to get extension instruction to set Nsh Spi Id {}", (Object)deviceId);
        }
        try {
            nsiIdTreatment.setPropertyValue("nshSi", (Object)NshServiceIndex.of((short)this.nshSi));
        }
        catch (Exception e) {
            this.log.error("Failed to get extension instruction to set Nsh Si Id {}", (Object)deviceId);
        }
        try {
            nshCh1Treatment.setPropertyValue("nshCh", (Object)NshContextHeader.of((int)1));
        }
        catch (Exception e) {
            this.log.error("Failed to get extension instruction to set NshCh1 {}", (Object)deviceId);
        }
        try {
            nshCh2Treatment.setPropertyValue("nshCh", (Object)NshContextHeader.of((int)Integer.parseInt(segmentationId.toString())));
        }
        catch (Exception e) {
            this.log.error("Failed to get extension instruction to set NshCh2 {}", (Object)deviceId);
        }
        try {
            nshCh3Treatment.setPropertyValue("nshCh", (Object)NshContextHeader.of((int)3));
        }
        catch (Exception e) {
            this.log.error("Failed to get extension instruction to set NshCh3 {}", (Object)deviceId);
        }
        try {
            nshCh4Treatment.setPropertyValue("nshCh", (Object)NshContextHeader.of((int)4));
        }
        catch (Exception e) {
            this.log.error("Failed to get extension instruction to set NshCh4 {}", (Object)deviceId);
        }
        treatmentBuilder.extension(pushNshTreatment, deviceId);
        treatmentBuilder.extension(nshMdTypeTreatment, deviceId);
        treatmentBuilder.extension(nshNpTreatment, deviceId);
        treatmentBuilder.extension(nspIdTreatment, deviceId);
        treatmentBuilder.extension(nsiIdTreatment, deviceId);
        treatmentBuilder.extension(nshCh1Treatment, deviceId);
        treatmentBuilder.extension(nshCh2Treatment, deviceId);
        treatmentBuilder.extension(nshCh3Treatment, deviceId);
        treatmentBuilder.extension(nshCh4Treatment, deviceId);
        return treatmentBuilder;
    }

    public DeviceId getControllerId(Device device, Iterable<Device> devices) {
        for (Device d : devices) {
            if (d.type() != Device.Type.CONTROLLER || !d.id().toString().contains(this.getControllerIpOfSwitch(device))) continue;
            return d.id();
        }
        this.log.info("Can not find controller for device : {}", (Object)device.id());
        return null;
    }

    public String getControllerIpOfSwitch(Device device) {
        String url = device.annotations().value(SWITCH_CHANNEL_ID);
        return url.substring(0, url.lastIndexOf(":"));
    }

    public void sendSfcRule(TrafficSelector.Builder selector, TrafficTreatment.Builder treatment, DeviceId deviceId, Objective.Operation type, int priority) {
        this.log.info("Sending sfc flow rule. Selector {}, Treatment {}", (Object)selector.toString(), (Object)treatment.toString());
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment.build()).withSelector(selector.build()).fromApp(this.appId).makePermanent().withFlag(ForwardingObjective.Flag.VERSATILE).withPriority(priority);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.log.debug("flowClassifierRules-->ADD");
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.log.debug("flowClassifierRules-->REMOVE");
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }

    private PortNumber getVxlanPortNumber(DeviceId deviceId) {
        List ports = this.deviceService.getPorts(deviceId);
        Port vxlanPort = Sets.newHashSet((Iterable)ports).stream().filter(p -> !p.number().equals((Object)PortNumber.LOCAL)).filter(p -> p.annotations().value("portName").startsWith(VXLANPORT_HEAD)).findFirst().get();
        return vxlanPort.number();
    }
}

