/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.messagingperf;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Dictionary;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.BoundedThreadPool;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.CoreService;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service(value={MessagingPerfApp.class})
public class MessagingPerfApp {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService communicationService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    private static final MessageSubject TEST_UNICAST_MESSAGE_TOPIC = new MessageSubject("net-perf-unicast-message");
    private static final MessageSubject TEST_REQUEST_REPLY_TOPIC = new MessageSubject("net-perf-rr-message");
    private static final int DEFAULT_SENDER_THREAD_POOL_SIZE = 2;
    private static final int DEFAULT_RECEIVER_THREAD_POOL_SIZE = 2;
    @Property(name="totalSenderThreads", intValue={2}, label="Number of sender threads")
    protected int totalSenderThreads = 2;
    @Property(name="totalReceiverThreads", intValue={2}, label="Number of receiver threads")
    protected int totalReceiverThreads = 2;
    @Property(name="serializationOn", boolValue={true}, label="Turn serialization on/off")
    private boolean serializationOn = true;
    @Property(name="receiveOnIOLoopThread", boolValue={false}, label="Set this to true to handle message on IO thread")
    private boolean receiveOnIOLoopThread = false;
    protected int reportIntervalSeconds = 1;
    private Executor messageReceivingExecutor;
    private ExecutorService messageSendingExecutor = BoundedThreadPool.newFixedThreadPool((int)this.totalSenderThreads, (ThreadFactory)Tools.groupedThreads((String)"onos/messaging-perf-test", (String)"sender-%d"));
    private final ScheduledExecutorService reporter = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/net-perf-test", (String)"reporter"));
    private AtomicInteger received = new AtomicInteger(0);
    private AtomicInteger sent = new AtomicInteger(0);
    private AtomicInteger attempted = new AtomicInteger(0);
    private AtomicInteger completed = new AtomicInteger(0);
    protected static final KryoSerializer SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(KryoNamespaces.BASIC).register(KryoNamespaces.MISC).register(new Class[]{Data.class}).build("MessagingPerfApp");
        }
    };
    private final Data data = new Data().withStringField("test").withListField(Lists.newArrayList((Object[])new String[]{"1", "2", "3"})).withSetField(Sets.newHashSet((Object[])new String[]{"1", "2", "3"}));
    private final byte[] dataBytes = SERIALIZER.encode((Object)new Data().withStringField("test").withListField(Lists.newArrayList((Object[])new String[]{"1", "2", "3"})).withSetField(Sets.newHashSet((Object[])new String[]{"1", "2", "3"})));
    private Function<Data, byte[]> encoder;
    private Function<byte[], Data> decoder;

    @Activate
    public void activate(ComponentContext context) {
        this.configService.registerProperties(this.getClass());
        this.setupCodecs();
        this.messageReceivingExecutor = this.receiveOnIOLoopThread ? MoreExecutors.directExecutor() : Executors.newFixedThreadPool(this.totalReceiverThreads, Tools.groupedThreads((String)"onos/net-perf-test", (String)"receiver-%d"));
        this.registerMessageHandlers();
        this.startTest();
        this.reporter.scheduleWithFixedDelay(this::reportPerformance, this.reportIntervalSeconds, this.reportIntervalSeconds, TimeUnit.SECONDS);
        this.logConfig("Started");
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.configService.unregisterProperties(this.getClass(), false);
        this.stopTest();
        this.reporter.shutdown();
        this.unregisterMessageHandlers();
        this.log.info("Stopped.");
    }

    @Modified
    public void modified(ComponentContext context) {
        boolean modified;
        if (context == null) {
            this.totalSenderThreads = 2;
            this.totalReceiverThreads = 2;
            this.serializationOn = true;
            this.receiveOnIOLoopThread = false;
            return;
        }
        Dictionary properties = context.getProperties();
        int newTotalSenderThreads = this.totalSenderThreads;
        int newTotalReceiverThreads = this.totalReceiverThreads;
        boolean newSerializationOn = this.serializationOn;
        boolean newReceiveOnIOLoopThread = this.receiveOnIOLoopThread;
        try {
            String s = Tools.get((Dictionary)properties, (String)"totalSenderThreads");
            newTotalSenderThreads = Strings.isNullOrEmpty((String)s) ? this.totalSenderThreads : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"totalReceiverThreads");
            newTotalReceiverThreads = Strings.isNullOrEmpty((String)s) ? this.totalReceiverThreads : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"serializationOn");
            newSerializationOn = Strings.isNullOrEmpty((String)s) ? this.serializationOn : Boolean.parseBoolean(s.trim());
            s = Tools.get((Dictionary)properties, (String)"receiveOnIOLoopThread");
            newReceiveOnIOLoopThread = Strings.isNullOrEmpty((String)s) ? this.receiveOnIOLoopThread : Boolean.parseBoolean(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            return;
        }
        boolean bl = modified = newTotalSenderThreads != this.totalSenderThreads || newTotalReceiverThreads != this.totalReceiverThreads || newSerializationOn != this.serializationOn || newReceiveOnIOLoopThread != this.receiveOnIOLoopThread;
        if (!modified) {
            return;
        }
        this.totalSenderThreads = newTotalSenderThreads;
        this.totalReceiverThreads = newTotalReceiverThreads;
        this.serializationOn = newSerializationOn;
        if (!this.receiveOnIOLoopThread && newReceiveOnIOLoopThread != this.receiveOnIOLoopThread) {
            ((ExecutorService)this.messageReceivingExecutor).shutdown();
        }
        this.receiveOnIOLoopThread = newReceiveOnIOLoopThread;
        this.stopTest();
        this.unregisterMessageHandlers();
        this.setupCodecs();
        this.messageSendingExecutor = BoundedThreadPool.newFixedThreadPool((int)this.totalSenderThreads, (ThreadFactory)Tools.groupedThreads((String)"onos/net-perf-test", (String)"sender-%d"));
        this.messageReceivingExecutor = this.receiveOnIOLoopThread ? MoreExecutors.directExecutor() : Executors.newFixedThreadPool(this.totalReceiverThreads, Tools.groupedThreads((String)"onos/net-perf-test", (String)"receiver-%d"));
        this.registerMessageHandlers();
        this.startTest();
        this.logConfig("Reconfigured");
    }

    private void logConfig(String prefix) {
        this.log.info("{} with senderThreadPoolSize = {}; receivingThreadPoolSize = {} serializationOn = {}, receiveOnIOLoopThread = {}", new Object[]{prefix, this.totalSenderThreads, this.totalReceiverThreads, this.serializationOn, this.receiveOnIOLoopThread});
    }

    private void setupCodecs() {
        Function<Data, byte[]> function = this.serializationOn ? arg_0 -> ((KryoSerializer)SERIALIZER).encode(arg_0) : (this.encoder = d -> this.dataBytes);
        this.decoder = this.serializationOn ? arg_0 -> ((KryoSerializer)SERIALIZER).decode(arg_0) : b -> this.data;
    }

    private void registerMessageHandlers() {
        this.communicationService.addSubscriber(TEST_UNICAST_MESSAGE_TOPIC, this.decoder, d -> this.received.incrementAndGet(), this.messageReceivingExecutor);
        this.communicationService.addSubscriber(TEST_REQUEST_REPLY_TOPIC, this.decoder, Function.identity(), this.encoder, this.messageReceivingExecutor);
    }

    private void unregisterMessageHandlers() {
        this.communicationService.removeSubscriber(TEST_UNICAST_MESSAGE_TOPIC);
        this.communicationService.removeSubscriber(TEST_REQUEST_REPLY_TOPIC);
    }

    private void startTest() {
        IntStream.range(0, this.totalSenderThreads).forEach(i -> this.requestReply());
    }

    private void stopTest() {
        this.messageSendingExecutor.shutdown();
    }

    private void requestReply() {
        try {
            this.attempted.incrementAndGet();
            CompletableFuture response = this.communicationService.sendAndReceive((Object)this.data, TEST_REQUEST_REPLY_TOPIC, this.encoder, this.decoder, this.randomPeer());
            response.whenComplete((result, error) -> {
                if (Objects.equals(this.data, result)) {
                    this.completed.incrementAndGet();
                }
                this.messageSendingExecutor.submit(this::requestReply);
            });
        }
        catch (Exception e) {
            this.log.info("requestReply()", (Throwable)e);
        }
    }

    private void unicast() {
        try {
            this.sent.incrementAndGet();
            this.communicationService.unicast((Object)this.data, TEST_UNICAST_MESSAGE_TOPIC, this.encoder, this.randomPeer());
        }
        catch (Exception e) {
            this.log.info("unicast()", (Throwable)e);
        }
        this.messageSendingExecutor.submit(this::unicast);
    }

    private void broadcast() {
        try {
            this.sent.incrementAndGet();
            this.communicationService.broadcast((Object)this.data, TEST_UNICAST_MESSAGE_TOPIC, this.encoder);
        }
        catch (Exception e) {
            this.log.info("broadcast()", (Throwable)e);
        }
        this.messageSendingExecutor.submit(this::broadcast);
    }

    private NodeId randomPeer() {
        return this.clusterService.getNodes().stream().filter(node -> this.clusterService.getLocalNode().equals(node)).findAny().get().id();
    }

    private void reportPerformance() {
        this.log.info("Attempted: {} Completed: {}", (Object)this.attempted.getAndSet(0), (Object)this.completed.getAndSet(0));
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindCommunicationService(ClusterCommunicationService clusterCommunicationService) {
        this.communicationService = clusterCommunicationService;
    }

    protected void unbindCommunicationService(ClusterCommunicationService clusterCommunicationService) {
        if (this.communicationService == clusterCommunicationService) {
            this.communicationService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }

    private static class Data {
        private String stringField;
        private List<String> listField;
        private Set<String> setField;

        private Data() {
        }

        public Data withStringField(String value) {
            this.stringField = value;
            return this;
        }

        public Data withListField(List<String> value) {
            this.listField = ImmutableList.copyOf(value);
            return this;
        }

        public Data withSetField(Set<String> value) {
            this.setField = ImmutableSet.copyOf(value);
            return this;
        }

        public int hashCode() {
            return Objects.hash(this.stringField, this.listField, this.setField);
        }

        public boolean equals(Object other) {
            if (other instanceof Data) {
                Data that = (Data)other;
                return Objects.equals(this.stringField, that.stringField) && Objects.equals(this.listField, that.listField) && Objects.equals(this.setField, that.setField);
            }
            return false;
        }
    }
}

