/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.distributedprimitives.cli;

import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.util.KryoNamespace;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WorkQueue;
import org.onosproject.store.service.WorkQueueStats;

@Command(scope="onos", name="work-queue-test", description="Test a distributed work queue")
public class WorkQueueTestCommand
extends AbstractShellCommand {
    @Argument(index=0, name="name", description="Work Queue name", required=true, multiValued=false)
    String name = null;
    @Argument(index=1, name="operation", description="operation name. One of {add, addMultiple, takeAndComplete, totalPending, totalInProgress, totalCompleted, destroy}", required=true, multiValued=false)
    String operation = null;
    @Argument(index=2, name="value1", description="first arg", required=false, multiValued=false)
    String value1 = null;
    @Argument(index=3, name="value2", description="second arg", required=false, multiValued=false)
    String value2 = null;
    WorkQueue<String> queue;

    protected void execute() {
        StorageService storageService = (StorageService)WorkQueueTestCommand.get(StorageService.class);
        Serializer serializer = Serializer.using((KryoNamespace)KryoNamespaces.BASIC);
        this.queue = storageService.getWorkQueue(this.name, serializer);
        if ("add".equals(this.operation)) {
            if (this.value1 == null) {
                this.print("Usage: add <value1>", new Object[0]);
            } else {
                this.get(this.queue.addOne((Object)this.value1));
                this.print("Done", new Object[0]);
            }
        } else if ("addMultiple".equals(this.operation)) {
            if (this.value1 == null || this.value2 == null) {
                this.print("Usage: addMultiple <value1> <value2>", new Object[0]);
            } else {
                this.get(this.queue.addMultiple(Arrays.asList(this.value1, this.value2)));
                this.print("Done", new Object[0]);
            }
        } else if ("takeAndComplete".equals(this.operation)) {
            int maxItems = this.value1 != null ? Integer.parseInt(this.value1) : 1;
            Collection tasks = (Collection)this.get(this.queue.take(maxItems));
            tasks.forEach(task -> {
                Void cfr_ignored_0 = (Void)this.get(this.queue.complete(new String[]{task.taskId()}));
            });
            this.print("Done", new Object[0]);
        } else if ("totalPending".equals(this.operation)) {
            WorkQueueStats stats = (WorkQueueStats)this.get(this.queue.stats());
            this.print("%d", new Object[]{stats.totalPending()});
        } else if ("totalInProgress".equals(this.operation)) {
            WorkQueueStats stats = (WorkQueueStats)this.get(this.queue.stats());
            this.print("%d", new Object[]{stats.totalInProgress()});
        } else if ("totalCompleted".equals(this.operation)) {
            WorkQueueStats stats = (WorkQueueStats)this.get(this.queue.stats());
            this.print("%d", new Object[]{stats.totalCompleted()});
        } else if ("destroy".equals(this.operation)) {
            this.get(this.queue.destroy());
        } else {
            this.print("Invalid operation name. Valid operations names are: [add, addMultiple takeAndComplete, totalPending, totalInProgress, totalCompleted, destroy]", new Object[0]);
        }
    }

    private <T> T get(CompletableFuture<T> future) {
        try {
            return future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

