/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.distributedprimitives.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.util.KryoNamespace;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncAtomicValue;
import org.onosproject.store.service.AtomicValue;
import org.onosproject.store.service.AtomicValueBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;

@Command(scope="onos", name="value-test", description="Manipulate a distributed value")
public class ValueTestCommand
extends AbstractShellCommand {
    @Argument(index=0, name="value", description="Value name", required=true, multiValued=false)
    String value = null;
    @Argument(index=1, name="operation", description="operation name", required=true, multiValued=false)
    String operation = null;
    @Argument(index=2, name="value1", description="first arg", required=false, multiValued=false)
    String value1 = null;
    @Argument(index=3, name="value2", description="second arg", required=false, multiValued=false)
    String value2 = null;
    AtomicValue<String> atomicValue;

    protected void execute() {
        StorageService storageService = (StorageService)ValueTestCommand.get(StorageService.class);
        this.atomicValue = ((AsyncAtomicValue)((AtomicValueBuilder)((AtomicValueBuilder)storageService.atomicValueBuilder().withName(this.value)).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.BASIC))).build()).asAtomicValue();
        if ("get".equals(this.operation)) {
            this.print("%s", new Object[]{this.atomicValue.get()});
        } else if ("set".equals(this.operation)) {
            this.atomicValue.set((Object)this.value1);
        } else if ("compareAndSet".equals(this.operation)) {
            this.print("%b", new Object[]{this.atomicValue.compareAndSet((Object)this.value1, (Object)this.value2)});
        } else if ("getAndSet".equals(this.operation)) {
            this.print("%s", new Object[]{this.atomicValue.getAndSet((Object)this.value1)});
        } else if ("destroy".equals(this.operation)) {
            this.atomicValue.destroy();
        } else {
            this.print("Error, unknown operation %s", new Object[]{this.operation});
        }
    }
}

