/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.distributedprimitives.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.util.KryoNamespace;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;

@Command(scope="onos", name="transactional-map-test-put", description="Put a value into a transactional map")
public class TransactionalMapTestPutCommand
extends AbstractShellCommand {
    @Argument(index=0, name="numKeys", description="Number of keys to put the value into", required=true, multiValued=false)
    private int numKeys = 1;
    @Argument(index=1, name="value", description="Value to map with the keys in the map", required=true, multiValued=false)
    private String value = null;
    TransactionalMap<String, String> map;
    String prefix = "Key";
    String mapName = "Test-Map";
    Serializer serializer = Serializer.using((KryoNamespace)KryoNamespaces.BASIC);

    protected void execute() {
        StorageService storageService = (StorageService)TransactionalMapTestPutCommand.get(StorageService.class);
        TransactionContext context = (TransactionContext)storageService.transactionContextBuilder().build();
        context.begin();
        try {
            this.map = context.getTransactionalMap(this.mapName, this.serializer);
            for (int i = 1; i <= this.numKeys; ++i) {
                String key = this.prefix + i;
                String response = (String)this.map.put((Object)key, (Object)this.value);
                if (response == null) {
                    this.print("Created Key %s with value %s.", new Object[]{key, this.value});
                    continue;
                }
                this.print("Put %s into key %s. The old value was %s.", new Object[]{this.value, key, response});
            }
            context.commit();
        }
        catch (Exception e) {
            context.abort();
            throw e;
        }
    }
}

