/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.distributedprimitives.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.util.KryoNamespace;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;

@Command(scope="onos", name="transactional-map-test-get", description="Get a value associated with a specific key in a transactional map")
public class TransactionalMapTestGetCommand
extends AbstractShellCommand {
    @Argument(index=0, name="key", description="Key to get the value of", required=true, multiValued=false)
    private String key = null;
    TransactionalMap<String, String> map;
    String mapName = "Test-Map";
    Serializer serializer = Serializer.using((KryoNamespace)KryoNamespaces.BASIC);

    protected void execute() {
        StorageService storageService = (StorageService)TransactionalMapTestGetCommand.get(StorageService.class);
        TransactionContext context = (TransactionContext)storageService.transactionContextBuilder().build();
        context.begin();
        try {
            this.map = context.getTransactionalMap(this.mapName, this.serializer);
            String response = (String)this.map.get((Object)this.key);
            context.commit();
            if (response == null) {
                this.print("Key %s not found.", new Object[]{this.key});
            } else {
                this.print("Key-value pair (%s, %s) found.", new Object[]{this.key, response});
            }
        }
        catch (Exception e) {
            context.abort();
            throw e;
        }
    }
}

