/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.distributedprimitives.cli;

import java.util.Arrays;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.util.KryoNamespace;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;

@Command(scope="onos", name="set-test-remove", description="Remove from a distributed set")
public class SetTestRemoveCommand
extends AbstractShellCommand {
    @Option(name="-r", aliases={"--retain"}, description="Only keep the given values in the set (if they already exist in the set)", required=false, multiValued=false)
    private boolean retain = false;
    @Option(name="-c", aliases={"--clear"}, description="Clear the set of all values", required=false, multiValued=false)
    private boolean clear = false;
    @Argument(index=0, name="setName", description="set name", required=true, multiValued=false)
    String setName = null;
    @Argument(index=1, name="values", description="Value(s) to remove from the set", required=false, multiValued=true)
    String[] values = null;
    Set<String> set;
    Serializer serializer = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.BASIC).build());

    protected void execute() {
        StorageService storageService = (StorageService)SetTestRemoveCommand.get(StorageService.class);
        this.set = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)storageService.setBuilder().withName(this.setName)).withSerializer(this.serializer)).build()).asDistributedSet();
        if (this.clear) {
            this.set.clear();
            this.print("Set %s cleared", new Object[]{this.setName});
            return;
        }
        if (this.values == null) {
            this.print("Error executing command: No value given", new Object[0]);
            return;
        }
        if (this.retain) {
            if (this.set.retainAll(Arrays.asList(this.values))) {
                this.print("%s was pruned to contain only elements of set %s", new Object[]{this.setName, Arrays.asList(this.values)});
            } else {
                this.print("%s was not changed by retaining only elements of the set %s", new Object[]{this.setName, Arrays.asList(this.values)});
            }
        } else if (this.values.length == 1) {
            if (this.set.remove(this.values[0])) {
                this.print("[%s] was removed from the set %s", new Object[]{this.values[0], this.setName});
            } else {
                this.print("[%s] was not in set %s", new Object[]{this.values[0], this.setName});
            }
        } else if (this.values.length > 1) {
            if (this.set.removeAll(Arrays.asList(this.values))) {
                this.print("%s was removed from the set %s", new Object[]{Arrays.asList(this.values), this.setName});
            } else {
                this.print("No element of %s was in set %s", new Object[]{Arrays.asList(this.values), this.setName});
            }
        }
    }
}

