/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.distributedprimitives.cli;

import java.util.Arrays;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.util.KryoNamespace;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;

@Command(scope="onos", name="set-test-get", description="Get the elements in a distributed set")
public class SetTestGetCommand
extends AbstractShellCommand {
    @Option(name="-s", aliases={"--size"}, description="Also show the size of the set?", required=false, multiValued=false)
    private boolean size = false;
    @Argument(index=0, name="setName", description="set name", required=true, multiValued=false)
    String setName = null;
    @Argument(index=1, name="values", description="Check if the set contains these value(s)", required=false, multiValued=true)
    String[] values = null;
    Set<String> set;
    String output = "";
    Serializer serializer = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.BASIC).build());

    protected void execute() {
        StorageService storageService = (StorageService)SetTestGetCommand.get(StorageService.class);
        this.set = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)storageService.setBuilder().withName(this.setName)).withSerializer(this.serializer)).build()).asDistributedSet();
        if (this.size) {
            this.print("There are %d items in set %s:", new Object[]{this.set.size(), this.setName});
        } else {
            this.print("Items in set %s:", new Object[]{this.setName});
        }
        if (this.set.isEmpty()) {
            this.print("[]", new Object[0]);
        } else {
            for (String e : this.set.toArray(new String[this.set.size()])) {
                this.output = this.output.isEmpty() ? this.output + e : this.output + ", " + e;
            }
            this.print("[%s]", new Object[]{this.output});
        }
        if (this.values == null) {
            return;
        }
        if (this.values.length == 1) {
            if (this.set.contains(this.values[0])) {
                this.print("Set %s contains the value %s", new Object[]{this.setName, this.values[0]});
            } else {
                this.print("Set %s did not contain the value %s", new Object[]{this.setName, this.values[0]});
            }
        } else if (this.values.length > 1) {
            if (this.set.containsAll(Arrays.asList(this.values))) {
                this.print("Set %s contains the the subset %s", new Object[]{this.setName, Arrays.asList(this.values)});
            } else {
                this.print("Set %s did not contain the the subset %s", new Object[]{this.setName, Arrays.asList(this.values)});
            }
        }
    }
}

