/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.distributedprimitives.cli;

import java.util.Arrays;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.util.KryoNamespace;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;

@Command(scope="onos", name="set-test-add", description="Add to a distributed set")
public class SetTestAddCommand
extends AbstractShellCommand {
    @Argument(index=0, name="setName", description="set name", required=true, multiValued=false)
    String setName = null;
    @Argument(index=1, name="values", description="Value(s) to add to the set", required=true, multiValued=true)
    String[] values = null;
    Set<String> set;
    Serializer serializer = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.BASIC).build());

    protected void execute() {
        StorageService storageService = (StorageService)SetTestAddCommand.get(StorageService.class);
        this.set = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)storageService.setBuilder().withName(this.setName)).withSerializer(this.serializer)).build()).asDistributedSet();
        if (this.values.length == 1) {
            if (this.set.add(this.values[0])) {
                this.print("[%s] was added to the set %s", new Object[]{this.values[0], this.setName});
            } else {
                this.print("[%s] was already in set %s", new Object[]{this.values[0], this.setName});
            }
        } else if (this.values.length >= 1) {
            if (this.set.addAll(Arrays.asList(this.values))) {
                this.print("%s was added to the set %s", new Object[]{Arrays.asList(this.values), this.setName});
            } else {
                this.print("%s was already in set %s", new Object[]{Arrays.asList(this.values), this.setName});
            }
        }
    }
}

