/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.distributedprimitives.cli;

import com.google.common.base.Joiner;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.LeaderElector;
import org.onosproject.store.service.LeaderElectorBuilder;
import org.onosproject.store.service.StorageService;

@Command(scope="onos", name="leader-test", description="LeaderElector test cli fixture")
public class LeaderElectorTestCommand
extends AbstractShellCommand {
    @Argument(index=0, name="name", description="leader elector name", required=true, multiValued=false)
    String name = null;
    @Argument(index=1, name="operation", description="operation", required=true, multiValued=false)
    String operation = null;
    @Argument(index=2, name="topic", description="topic name", required=false, multiValued=false)
    String topic = null;
    LeaderElector leaderElector;

    protected void execute() {
        StorageService storageService = (StorageService)LeaderElectorTestCommand.get(StorageService.class);
        ClusterService clusterService = (ClusterService)LeaderElectorTestCommand.get(ClusterService.class);
        NodeId localNodeId = clusterService.getLocalNode().id();
        this.leaderElector = ((AsyncLeaderElector)((LeaderElectorBuilder)storageService.leaderElectorBuilder().withName(this.name)).build()).asLeaderElector();
        if ("run".equals(this.operation)) {
            this.print(this.leaderElector.run(this.topic, localNodeId));
        } else if ("withdraw".equals(this.operation)) {
            this.leaderElector.withdraw(this.topic);
        } else if ("show".equals(this.operation)) {
            this.print(this.leaderElector.getLeadership(this.topic));
        }
    }

    private void print(Leadership leadership) {
        if (leadership.leader() != null) {
            this.print("leader=%s#term=%d#candidates=%s", new Object[]{leadership.leaderNodeId(), leadership.leader().term(), leadership.candidates().isEmpty() ? "none" : Joiner.on((String)",").join((Iterable)leadership.candidates())});
        } else {
            this.print("leader=none#candidates=%s", new Object[]{leadership.candidates().isEmpty() ? "none" : Joiner.on((String)",").join((Iterable)leadership.candidates())});
        }
    }
}

