/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.distributedprimitives.cli;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="onos", name="counter-test-increment", description="Increment a distributed counter")
public class CounterTestIncrementCommand
extends AbstractShellCommand {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Option(name="-g", aliases={"--getFirst"}, description="get the counter's value before adding", required=false, multiValued=false)
    private boolean getFirst = false;
    @Argument(index=0, name="counter", description="Counter name", required=true, multiValued=false)
    String counter = null;
    @Argument(index=1, name="delta", description="Long to add to the counter", required=false, multiValued=false)
    Long delta = null;
    AsyncAtomicCounter atomicCounter;

    protected void execute() {
        StorageService storageService = (StorageService)CounterTestIncrementCommand.get(StorageService.class);
        this.atomicCounter = storageService.getAsyncAtomicCounter(this.counter);
        CompletableFuture result = this.delta != null ? (this.getFirst ? this.atomicCounter.getAndAdd(this.delta.longValue()) : this.atomicCounter.addAndGet(this.delta.longValue())) : (this.getFirst ? this.atomicCounter.getAndIncrement() : this.atomicCounter.incrementAndGet());
        try {
            this.print("%s was updated to %d", new Object[]{this.counter, result.get(3L, TimeUnit.SECONDS)});
        }
        catch (InterruptedException e) {
            return;
        }
        catch (ExecutionException | TimeoutException e) {
            this.print("Error executing command", new Object[0]);
            this.log.error("Error executing command counter-test-increment", (Throwable)e);
        }
    }
}

