/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.distributedprimitives.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.StorageService;

@Command(scope="onos", name="counter-test", description="Manipulate a distributed counter")
public class CounterTestCommand
extends AbstractShellCommand {
    @Argument(index=0, name="counter", description="Counter name", required=true, multiValued=false)
    String counter = null;
    @Argument(index=1, name="operation", description="operation name", required=true, multiValued=false)
    String operation = null;
    @Argument(index=2, name="value1", description="first arg", required=false, multiValued=false)
    Long value1 = null;
    @Argument(index=3, name="value2", description="second arg", required=false, multiValued=false)
    Long value2 = null;
    AtomicCounter atomicCounter;

    protected void execute() {
        StorageService storageService = (StorageService)CounterTestCommand.get(StorageService.class);
        this.atomicCounter = storageService.getAsyncAtomicCounter(this.counter).asAtomicCounter();
        if ("get".equals(this.operation)) {
            this.print("%d", new Object[]{this.atomicCounter.get()});
        } else if ("set".equals(this.operation)) {
            this.atomicCounter.set(this.value1.longValue());
        } else if ("incrementAndGet".equals(this.operation)) {
            this.print("%d", new Object[]{this.atomicCounter.incrementAndGet()});
        } else if ("getAndIncrement".equals(this.operation)) {
            this.print("%d", new Object[]{this.atomicCounter.getAndIncrement()});
        } else if ("getAndAdd".equals(this.operation)) {
            this.print("%d", new Object[]{this.atomicCounter.getAndAdd(this.value1.longValue())});
        } else if ("addAndGet".equals(this.operation)) {
            this.print("%d", new Object[]{this.atomicCounter.addAndGet(this.value1.longValue())});
        } else if ("compareAndSet".equals(this.operation)) {
            this.print("%b", new Object[]{this.atomicCounter.compareAndSet(this.value1.longValue(), this.value2.longValue())});
        } else if ("destroy".equals(this.operation)) {
            this.atomicCounter.destroy();
        }
    }
}

