/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.distributedprimitives.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.util.KryoNamespace;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;

@Command(scope="onos", name="map-test", description="Manipulate a consistent map")
public class ConsistentMapTestCommand
extends AbstractShellCommand {
    @Argument(index=0, name="name", description="map name", required=true, multiValued=false)
    String name = null;
    @Argument(index=1, name="operation", description="operation name", required=true, multiValued=false)
    String operation = null;
    @Argument(index=2, name="key", description="first arg", required=false, multiValued=false)
    String arg1 = null;
    @Argument(index=3, name="value1", description="second arg", required=false, multiValued=false)
    String arg2 = null;
    @Argument(index=4, name="value2", description="third arg", required=false, multiValued=false)
    String arg3 = null;
    ConsistentMap<String, String> map;

    protected void execute() {
        StorageService storageService = (StorageService)ConsistentMapTestCommand.get(StorageService.class);
        this.map = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)storageService.consistentMapBuilder().withName(this.name)).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.BASIC))).build();
        if ("get".equals(this.operation)) {
            this.print((Versioned<String>)this.map.get((Object)this.arg1));
        } else if ("put".equals(this.operation)) {
            this.print((Versioned<String>)this.map.put((Object)this.arg1, (Object)this.arg2));
        } else if ("size".equals(this.operation)) {
            this.print("%d", new Object[]{this.map.size()});
        } else if ("isEmpty".equals(this.operation)) {
            this.print("%b", new Object[]{this.map.isEmpty()});
        } else if ("putIfAbsent".equals(this.operation)) {
            this.print((Versioned<String>)this.map.putIfAbsent((Object)this.arg1, (Object)this.arg2));
        } else if ("putAndGet".equals(this.operation)) {
            this.print((Versioned<String>)this.map.putAndGet((Object)this.arg1, (Object)this.arg2));
        } else if ("clear".equals(this.operation)) {
            this.map.clear();
        } else if ("remove".equals(this.operation)) {
            if (this.arg2 == null) {
                this.print((Versioned<String>)this.map.remove((Object)this.arg1));
            } else {
                this.print("%b", new Object[]{this.map.remove((Object)this.arg1, (Object)this.arg2)});
            }
        } else if ("containsKey".equals(this.operation)) {
            this.print("%b", new Object[]{this.map.containsKey((Object)this.arg1)});
        } else if ("containsValue".equals(this.operation)) {
            this.print("%b", new Object[]{this.map.containsValue((Object)this.arg1)});
        } else if ("replace".equals(this.operation)) {
            if (this.arg3 == null) {
                this.print((Versioned<String>)this.map.replace((Object)this.arg1, (Object)this.arg2));
            } else {
                this.print("%b", new Object[]{this.map.replace((Object)this.arg1, (Object)this.arg2, (Object)this.arg3)});
            }
        }
    }

    void print(Versioned<String> value) {
        if (value == null) {
            this.print("null", new Object[0]);
        } else {
            this.print("%s", new Object[]{value.value()});
        }
    }
}

