/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.distributedprimitives;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={DistributedPrimitivesTest.class})
public class DistributedPrimitivesTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String APP_NAME = "org.onosproject.distributedprimitives";
    private ApplicationId appId;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private final Map<String, EventuallyConsistentMap<String, String>> maps = Maps.newConcurrentMap();

    @Activate
    protected void activate() {
        this.log.info("Distributed-Primitives-test app started");
        this.appId = this.coreService.registerApplication(APP_NAME);
    }

    @Deactivate
    protected void deactivate() {
        this.log.info("Distributed-Primitives-test app Stopped");
    }

    public EventuallyConsistentMap<String, String> getEcMap(String name) {
        return this.maps.computeIfAbsent(name, n -> this.storageService.eventuallyConsistentMapBuilder().withName(name).withSerializer(KryoNamespaces.API).withTimestampProvider((k, v) -> new WallClockTimestamp()).build());
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

