/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.ciena;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.optical.device.OchPortHelper;
import org.onosproject.net.optical.device.OduCltPortHelper;
import org.onosproject.protocol.rest.RestSBController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CienaWaveserverDeviceDescription
extends AbstractHandlerBehaviour
implements DeviceDescriptionDiscovery {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PORT_ID = "ptp-index";
    private static final String XML = "xml";
    private static final String ENABLED = "enabled";
    private static final String ADMIN_STATE = "state.admin-state";
    private static final String PORTS = "ws-ptps.ptps";
    private static final String PORT_IN = "properties.line-system.cmd.port-in";
    private static final String PORT_OUT = "properties.line-system.cmd.port-out";
    private static final ArrayList<String> LINESIDE_PORT_ID = Lists.newArrayList((Object[])new String[]{"4", "48"});
    private static final String PORT_REQUEST = "ciena-ws-ptp:ws-ptps?config=true&format=xml&depth=unbounded";

    public DeviceDescription discoverDeviceDetails() {
        this.log.info("No description to be added for device");
        return null;
    }

    public List<PortDescription> discoverPortDetails() {
        return this.getPorts();
    }

    private List<PortDescription> getPorts() {
        ArrayList ports = Lists.newArrayList();
        RestSBController controller = (RestSBController)Preconditions.checkNotNull((Object)this.handler().get(RestSBController.class));
        DeviceId deviceId = this.handler().data().deviceId();
        HierarchicalConfiguration config = XmlConfigParser.loadXml((InputStream)controller.get(deviceId, PORT_REQUEST, XML));
        List<HierarchicalConfiguration> portsConfig = CienaWaveserverDeviceDescription.parseWaveServerCienaPorts(config);
        portsConfig.forEach(sub -> {
            String portId = sub.getString(PORT_ID);
            DefaultAnnotations.Builder annotations = DefaultAnnotations.builder();
            if (LINESIDE_PORT_ID.contains(portId)) {
                annotations.set("portName", portId + " TX");
                ports.add(CienaWaveserverDeviceDescription.parseWaveServerCienaOchPorts(sub.getLong(PORT_OUT), sub, (SparseAnnotations)annotations.build()));
                annotations.set("portName", portId + " RX");
                ports.add(CienaWaveserverDeviceDescription.parseWaveServerCienaOchPorts(sub.getLong(PORT_IN), sub, (SparseAnnotations)annotations.build()));
            } else if (!portId.equals("5") && !portId.equals("49")) {
                DefaultAnnotations.builder().set("portName", portId);
                ports.add(OduCltPortHelper.oduCltPortDescription((PortNumber)PortNumber.portNumber((long)sub.getLong(PORT_ID)), (boolean)sub.getString(ADMIN_STATE).equals(ENABLED), (CltSignalType)CltSignalType.CLT_100GBE, (SparseAnnotations)annotations.build()));
            }
        });
        return ImmutableList.copyOf((Collection)ports);
    }

    public static List<HierarchicalConfiguration> parseWaveServerCienaPorts(HierarchicalConfiguration cfg) {
        return cfg.configurationsAt(PORTS);
    }

    public static PortDescription parseWaveServerCienaOchPorts(long portNumber, HierarchicalConfiguration config, SparseAnnotations annotations) {
        ArrayList tunableType = Lists.newArrayList((Object[])new String[]{"performance-optimized", "accelerated"});
        String flexGrid = "flex-grid";
        String state = "properties.transmitter.state";
        String tunable = "properties.modem.tx-tuning-mode";
        String spacing = "properties.line-system.wavelength-spacing";
        String frequency = "properties.transmitter.frequency.value";
        boolean isEnabled = config.getString("properties.transmitter.state").equals(ENABLED);
        boolean isTunable = tunableType.contains(config.getString("properties.modem.tx-tuning-mode"));
        GridType gridType = config.getString("properties.line-system.wavelength-spacing").equals("flex-grid") ? GridType.FLEX : null;
        ChannelSpacing chSpacing = gridType == GridType.FLEX ? ChannelSpacing.CHL_6P25GHZ : null;
        int baseFrequency = 193100;
        int spacingMult = (int)(CienaWaveserverDeviceDescription.toGbps((int)config.getDouble("properties.transmitter.frequency.value") - 193100) / CienaWaveserverDeviceDescription.toGbpsFromHz(chSpacing.frequency().asHz()));
        return OchPortHelper.ochPortDescription((PortNumber)PortNumber.portNumber((long)portNumber), (boolean)isEnabled, (OduSignalType)OduSignalType.ODU4, (boolean)isTunable, (OchSignal)new OchSignal(gridType, chSpacing, spacingMult, 1), (SparseAnnotations)annotations);
    }

    private static long toGbps(long speed) {
        return speed * 1000L;
    }

    private static long toGbpsFromHz(long speed) {
        return speed / 1000L;
    }
}

