/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcp.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onlab.util.KryoNamespace;
import org.onosproject.dhcp.DhcpStore;
import org.onosproject.dhcp.IpAssignment;
import org.onosproject.dhcp.impl.DistributedDhcpStore;
import org.onosproject.net.HostId;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedDhcpStore
implements DhcpStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<HostId, IpAssignment> allocationMap;
    private DistributedSet<Ip4Address> freeIPPool;
    private static Ip4Address startIPRange;
    private static Ip4Address endIPRange;
    private static int timeoutForPendingAssignments;

    @Activate
    protected void activate() {
        this.allocationMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-dhcp-assignedIP")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{IpAssignment.class, IpAssignment.AssignmentStatus.class, Date.class}).build("dhcp")))).build();
        this.freeIPPool = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName("onos-dhcp-freeIP")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).build()).asDistributedSet();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.log.info("Stopped");
    }

    public Ip4Address suggestIP(HostId hostId, Ip4Address requestedIP) {
        Ip4Address nextIPAddr;
        IpAssignment assignmentInfo;
        if (this.allocationMap.containsKey((Object)hostId)) {
            assignmentInfo = (IpAssignment)this.allocationMap.get((Object)hostId).value();
            IpAssignment.AssignmentStatus status = assignmentInfo.assignmentStatus();
            Ip4Address ipAddr = assignmentInfo.ipAddress();
            if (assignmentInfo.assignmentStatus().equals((Object)IpAssignment.AssignmentStatus.Option_RangeNotEnforced)) {
                return assignmentInfo.ipAddress();
            }
            if (status == IpAssignment.AssignmentStatus.Option_Assigned || status == IpAssignment.AssignmentStatus.Option_Requested) {
                if (this.ipWithinRange(ipAddr)) {
                    return ipAddr;
                }
            } else if (status == IpAssignment.AssignmentStatus.Option_Expired && this.freeIPPool.contains((Object)ipAddr)) {
                assignmentInfo = IpAssignment.builder().ipAddress(ipAddr).timestamp(new Date()).leasePeriod(timeoutForPendingAssignments).assignmentStatus(IpAssignment.AssignmentStatus.Option_Requested).build();
                if (this.freeIPPool.remove((Object)ipAddr)) {
                    this.allocationMap.put((Object)hostId, (Object)assignmentInfo);
                    return ipAddr;
                }
            }
        } else if (requestedIP.toInt() != 0 && this.freeIPPool.contains((Object)requestedIP)) {
            assignmentInfo = IpAssignment.builder().ipAddress(requestedIP).timestamp(new Date()).leasePeriod(timeoutForPendingAssignments).assignmentStatus(IpAssignment.AssignmentStatus.Option_Requested).build();
            if (this.freeIPPool.remove((Object)requestedIP)) {
                this.allocationMap.put((Object)hostId, (Object)assignmentInfo);
                return requestedIP;
            }
        }
        if ((nextIPAddr = this.fetchNextIP()) != null) {
            assignmentInfo = IpAssignment.builder().ipAddress(nextIPAddr).timestamp(new Date()).leasePeriod(timeoutForPendingAssignments).assignmentStatus(IpAssignment.AssignmentStatus.Option_Requested).build();
            this.allocationMap.put((Object)hostId, (Object)assignmentInfo);
        }
        return nextIPAddr;
    }

    public boolean assignIP(HostId hostId, IpAssignment ipAssignment) {
        this.log.trace("Assign IP Called HostId: {}, ipAssignment: {}", (Object)hostId, (Object)ipAssignment);
        IpAssignment newAssignment = null;
        Versioned versionedAssignment = this.allocationMap.get((Object)hostId);
        Ip4Address requestedIp = ipAssignment.ipAddress();
        if (versionedAssignment == null) {
            if (ipAssignment.assignmentStatus().equals((Object)IpAssignment.AssignmentStatus.Option_RangeNotEnforced)) {
                newAssignment = ipAssignment;
            } else if (this.freeIPPool.remove((Object)requestedIp)) {
                newAssignment = IpAssignment.builder((IpAssignment)ipAssignment).assignmentStatus(IpAssignment.AssignmentStatus.Option_Assigned).timestamp(new Date()).build();
            } else {
                this.log.trace("Failed to assign IP for {}", (Object)ipAssignment);
                return false;
            }
            this.log.trace("Assigned {}", (Object)newAssignment);
            return this.allocationMap.putIfAbsent((Object)hostId, (Object)newAssignment) == null;
        }
        IpAssignment existingAssignment = (IpAssignment)versionedAssignment.value();
        if (!existingAssignment.ipAddress().equals((Object)requestedIp)) {
            this.log.trace("Failed to assign IP for {}", (Object)ipAssignment);
            return false;
        }
        switch (1.$SwitchMap$org$onosproject$dhcp$IpAssignment$AssignmentStatus[existingAssignment.assignmentStatus().ordinal()]) {
            case 1: {
                newAssignment = IpAssignment.builder((IpAssignment)existingAssignment).timestamp(new Date()).build();
                break;
            }
            case 2: {
                if (!this.freeIPPool.remove((Object)requestedIp)) {
                    return false;
                }
            }
            case 3: 
            case 4: {
                newAssignment = IpAssignment.builder((IpAssignment)existingAssignment).timestamp(new Date()).assignmentStatus(IpAssignment.AssignmentStatus.Option_Assigned).build();
                break;
            }
        }
        this.log.trace("Assigned {}", (Object)newAssignment);
        return this.allocationMap.replace((Object)hostId, versionedAssignment.version(), (Object)newAssignment);
    }

    public Ip4Address releaseIP(HostId hostId) {
        if (this.allocationMap.containsKey((Object)hostId)) {
            Versioned assignmentVersioned = this.allocationMap.get((Object)hostId);
            if (Versioned.valueOrNull((Versioned)assignmentVersioned) != null && ((IpAssignment)assignmentVersioned.value()).assignmentStatus().equals((Object)IpAssignment.AssignmentStatus.Option_RangeNotEnforced)) {
                return null;
            }
            IpAssignment newAssignment = IpAssignment.builder((IpAssignment)((IpAssignment)this.allocationMap.get((Object)hostId).value())).assignmentStatus(IpAssignment.AssignmentStatus.Option_Expired).build();
            Ip4Address freeIP = newAssignment.ipAddress();
            this.allocationMap.put((Object)hostId, (Object)newAssignment);
            if (this.ipWithinRange(freeIP)) {
                this.freeIPPool.add((Object)freeIP);
            }
            return freeIP;
        }
        return null;
    }

    public void setDefaultTimeoutForPurge(int timeInSeconds) {
        timeoutForPendingAssignments = timeInSeconds;
    }

    public Map<HostId, IpAssignment> listAssignedMapping() {
        HashMap<HostId, IpAssignment> validMapping = new HashMap<HostId, IpAssignment>();
        for (Map.Entry entry : this.allocationMap.entrySet()) {
            IpAssignment assignment = (IpAssignment)((Versioned)entry.getValue()).value();
            if (assignment.assignmentStatus() != IpAssignment.AssignmentStatus.Option_Assigned && assignment.assignmentStatus() != IpAssignment.AssignmentStatus.Option_RangeNotEnforced) continue;
            validMapping.put((HostId)entry.getKey(), assignment);
        }
        return validMapping;
    }

    public Map<HostId, IpAssignment> listAllMapping() {
        HashMap<HostId, IpAssignment> validMapping = new HashMap<HostId, IpAssignment>();
        for (Map.Entry entry : this.allocationMap.entrySet()) {
            validMapping.put((HostId)entry.getKey(), (IpAssignment)((Versioned)entry.getValue()).value());
        }
        return validMapping;
    }

    public boolean assignStaticIP(MacAddress macAddress, IpAssignment ipAssignment) {
        HostId host = HostId.hostId((MacAddress)macAddress);
        return this.assignIP(host, ipAssignment);
    }

    public boolean removeStaticIP(MacAddress macID) {
        HostId host = HostId.hostId((MacAddress)macID);
        if (this.allocationMap.containsKey((Object)host)) {
            IpAssignment assignment = (IpAssignment)this.allocationMap.get((Object)host).value();
            if (assignment.assignmentStatus().equals((Object)IpAssignment.AssignmentStatus.Option_RangeNotEnforced)) {
                this.allocationMap.remove((Object)host);
                return true;
            }
            Ip4Address freeIP = assignment.ipAddress();
            if (assignment.leasePeriod() < 0) {
                this.allocationMap.remove((Object)host);
                if (this.ipWithinRange(freeIP)) {
                    this.freeIPPool.add((Object)freeIP);
                }
                return true;
            }
        }
        return false;
    }

    public Iterable<Ip4Address> getAvailableIPs() {
        return ImmutableSet.copyOf((Collection)this.freeIPPool);
    }

    public void populateIPPoolfromRange(Ip4Address startIP, Ip4Address endIP) {
        this.allocationMap.clear();
        this.freeIPPool.clear();
        startIPRange = startIP;
        endIPRange = endIP;
        int lastIP = endIP.toInt();
        for (int loopCounter = startIP.toInt(); loopCounter <= lastIP; ++loopCounter) {
            Ip4Address nextIP = Ip4Address.valueOf((int)loopCounter);
            this.freeIPPool.add((Object)nextIP);
        }
        this.log.debug("Updated free IP pool {}:{} size:{}", new Object[]{startIP, endIP, this.freeIPPool.size()});
    }

    public IpAssignment getIpAssignmentFromAllocationMap(HostId hostId) {
        if (this.allocationMap.get((Object)hostId) != null) {
            return (IpAssignment)this.allocationMap.get((Object)hostId).value();
        }
        return null;
    }

    private Ip4Address fetchNextIP() {
        for (Ip4Address freeIP : this.freeIPPool) {
            if (!this.freeIPPool.remove((Object)freeIP)) continue;
            return freeIP;
        }
        return null;
    }

    private boolean ipWithinRange(Ip4Address ip) {
        return ip.toInt() >= startIPRange.toInt() && ip.toInt() <= endIPRange.toInt();
    }

    static {
        timeoutForPendingAssignments = 60;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

