/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcp.cli;

import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.dhcp.DhcpService;

@Command(scope="onos", name="dhcp-lease", description="Lists all the default lease parameters offered by the DHCP Server")
public class DhcpLeaseDetails
extends AbstractShellCommand {
    private static final String DHCP_LEASE_FORMAT = "Lease Time: %ds\nRenewal Time: %ds\nRebinding Time: %ds";

    protected void execute() {
        DhcpService dhcpService = (DhcpService)AbstractShellCommand.get(DhcpService.class);
        int leaseTime = dhcpService.getLeaseTime();
        int renewTime = dhcpService.getRenewalTime();
        int rebindTime = dhcpService.getRebindingTime();
        this.print(DHCP_LEASE_FORMAT, new Object[]{leaseTime, renewTime, rebindTime});
    }
}

