/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.netconf.device.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.config.basics.ConfigException;
import org.onosproject.net.config.Config;

@Deprecated
@Beta
public class NetconfProviderConfig
extends Config<ApplicationId> {
    public static final String CONFIG_VALUE_ERROR = "Error parsing config value";
    private static final String IP = "ip";
    private static final int DEFAULT_TCP_PORT = 830;
    private static final String PORT = "port";
    private static final String NAME = "username";
    private static final String PASSWORD = "password";
    private static final String SSHKEY = "sshkey";

    public Set<NetconfDeviceAddress> getDevicesAddresses() throws ConfigException {
        HashSet devicesAddresses = Sets.newHashSet();
        try {
            for (JsonNode node : this.array) {
                String ip = node.path(IP).asText();
                IpAddress ipAddr = ip.isEmpty() ? null : IpAddress.valueOf((String)ip);
                int port = node.path(PORT).asInt(830);
                String name = node.path(NAME).asText();
                String password = node.path(PASSWORD).asText();
                String sshkey = node.path(SSHKEY).asText();
                devicesAddresses.add(new NetconfDeviceAddress(ipAddr, port, name, password, sshkey));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(CONFIG_VALUE_ERROR, (Throwable)e);
        }
        return devicesAddresses;
    }

    public class NetconfDeviceAddress {
        private final IpAddress ip;
        private final int port;
        private final String name;
        private final String password;
        private final String sshkey;

        public NetconfDeviceAddress(IpAddress ip, int port, String name, String password) {
            this.ip = ip;
            this.port = port;
            this.name = name;
            this.password = password;
            this.sshkey = "";
        }

        public NetconfDeviceAddress(IpAddress ip, int port, String name, String password, String sshkey) {
            this.ip = ip;
            this.port = port;
            this.name = name;
            this.password = password;
            this.sshkey = sshkey;
        }

        public IpAddress ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public String name() {
            return this.name;
        }

        public String password() {
            return this.password;
        }

        public String sshkey() {
            return this.sshkey;
        }
    }
}

