/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.netconf.device.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.config.basics.ConfigException;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.PortDiscovery;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortStatisticsDiscovery;
import org.onosproject.net.key.DeviceKey;
import org.onosproject.net.key.DeviceKeyAdminService;
import org.onosproject.net.key.DeviceKeyId;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDeviceListener;
import org.onosproject.netconf.NetconfException;
import org.onosproject.provider.netconf.device.impl.NetconfDeviceConfig;
import org.onosproject.provider.netconf.device.impl.NetconfProviderConfig;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class NetconfDeviceProvider
extends AbstractProvider
implements DeviceProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetconfController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceKeyAdminService deviceKeyAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService componentConfigService;
    protected static final String APP_NAME = "org.onosproject.netconf";
    protected static final String SCHEME_NAME = "netconf";
    private static final String DEVICE_PROVIDER_PACKAGE = "org.onosproject.netconf.provider.device";
    private static final String UNKNOWN = "unknown";
    protected static final String ISNULL = "NetconfDeviceInfo is null";
    private static final String IPADDRESS = "ipaddress";
    private static final String NETCONF = "netconf";
    private static final String PORT = "port";
    private static final int CORE_POOL_SIZE = 10;
    private static final int DEFAULT_POLL_FREQUENCY_SECONDS = 30;
    @Property(name="pollFrequency", intValue={30}, label="Configure poll frequency for port status and statistics; default is 30 sec")
    private int pollFrequency = 30;
    protected final ExecutorService executor = Executors.newFixedThreadPool(5, Tools.groupedThreads((String)"onos/netconfdeviceprovider", (String)"device-installer-%d", (Logger)this.log));
    protected ScheduledExecutorService connectionExecutor = Executors.newScheduledThreadPool(10, Tools.groupedThreads((String)"onos/netconfdeviceprovider", (String)"connection-executor-%d", (Logger)this.log));
    protected DeviceProviderService providerService;
    private NetconfDeviceListener innerNodeListener = new InnerNetconfDeviceListener();
    private InternalDeviceListener deviceListener = new InternalDeviceListener();
    protected ScheduledFuture<?> scheduledTask;
    protected final List<ConfigFactory> factories = ImmutableList.of((Object)new ConfigFactory<DeviceId, NetconfDeviceConfig>(SubjectFactories.DEVICE_SUBJECT_FACTORY, NetconfDeviceConfig.class, "netconf"){

        public NetconfDeviceConfig createConfig() {
            return new NetconfDeviceConfig();
        }
    }, (Object)new ConfigFactory<ApplicationId, NetconfProviderConfig>(SubjectFactories.APP_SUBJECT_FACTORY, NetconfProviderConfig.class, "devices", true){

        public NetconfProviderConfig createConfig() {
            return new NetconfProviderConfig();
        }
    });
    protected final NetworkConfigListener cfgListener = new InternalNetworkConfigListener();
    private ApplicationId appId;
    private boolean active;

    @Activate
    public void activate(ComponentContext context) {
        this.active = true;
        this.componentConfigService.registerProperties(((Object)((Object)this)).getClass());
        this.providerService = (DeviceProviderService)this.providerRegistry.register((Provider)this);
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgService).registerConfigFactory(arg_0));
        this.cfgService.addListener((EventListener)this.cfgListener);
        this.controller.addDeviceListener(this.innerNodeListener);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.translateConfig();
        this.executor.execute(this::connectDevices);
        this.modified(context);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.componentConfigService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.active = false;
        this.controller.getNetconfDevices().forEach(id -> {
            this.deviceKeyAdminService.removeKey(DeviceKeyId.deviceKeyId((String)id.toString()));
            this.controller.disconnectDevice(id, true);
        });
        this.controller.removeDeviceListener(this.innerNodeListener);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgService).unregisterConfigFactory(arg_0));
        this.scheduledTask.cancel(true);
        this.executor.shutdown();
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        if (context != null) {
            Dictionary properties = context.getProperties();
            this.pollFrequency = Tools.getIntegerProperty((Dictionary)properties, (String)"pollFrequency", (int)30);
            this.log.info("Configured. Poll frequency is configured to {} seconds", (Object)this.pollFrequency);
        }
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
        }
        this.scheduledTask = this.schedulePolling();
    }

    public NetconfDeviceProvider() {
        super(new ProviderId("netconf", DEVICE_PROVIDER_PACKAGE));
    }

    private ScheduledFuture schedulePolling() {
        return this.connectionExecutor.scheduleAtFixedRate(this.exceptionSafe(this::checkAndUpdateDevices), this.pollFrequency / 10, this.pollFrequency, TimeUnit.SECONDS);
    }

    private Runnable exceptionSafe(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    NetconfDeviceProvider.this.log.error("Unhandled Exception", (Throwable)e);
                }
            }
        };
    }

    public void triggerProbe(DeviceId deviceId) {
        this.log.debug("Should be triggering probe on device {}", (Object)deviceId);
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
        if (this.active) {
            switch (newRole) {
                case MASTER: {
                    this.initiateConnection(deviceId, newRole);
                    this.log.debug("Accepting mastership role change to {} for device {}", (Object)newRole, (Object)deviceId);
                    break;
                }
                case STANDBY: {
                    this.controller.disconnectDevice(deviceId, false);
                    this.providerService.receivedRoleReply(deviceId, newRole, MastershipRole.STANDBY);
                    break;
                }
                case NONE: {
                    this.controller.disconnectDevice(deviceId, false);
                    this.providerService.receivedRoleReply(deviceId, newRole, MastershipRole.NONE);
                    break;
                }
                default: {
                    this.log.error("Unimplemented Mastership state : {}", (Object)newRole);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isReachable(DeviceId deviceId) {
        int port;
        String ip;
        Device device = this.deviceService.getDevice(deviceId);
        if (device != null) {
            ip = device.annotations().value(IPADDRESS);
            port = Integer.parseInt(device.annotations().value(PORT));
        } else {
            String[] info = deviceId.toString().split(":");
            if (info.length == 3) {
                ip = info[1];
                port = Integer.parseInt(info[2]);
            } else {
                ip = Arrays.asList(info).stream().filter(el -> !el.equals(info[0]) && !el.equals(info[info.length - 1])).reduce((t, u) -> t + ":" + u).get();
                this.log.debug("ip v6 {}", (Object)ip);
                port = Integer.parseInt(info[info.length - 1]);
            }
        }
        try (Socket socket = new Socket(ip, port);){
            this.log.debug("rechability of {}, {}, {}", new Object[]{deviceId, socket.isConnected(), !socket.isClosed()});
            boolean bl = socket.isConnected() && !socket.isClosed();
            return bl;
        }
        catch (IOException e) {
            this.log.info("Device {} is not reachable", (Object)deviceId);
            return false;
        }
    }

    public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
    }

    private void connectDevices() {
        Set deviceSubjects = this.cfgService.getSubjects(DeviceId.class, NetconfDeviceConfig.class);
        deviceSubjects.forEach(deviceId -> {
            NetconfDeviceConfig config = (NetconfDeviceConfig)this.cfgService.getConfig(deviceId, NetconfDeviceConfig.class);
            DeviceDescription deviceDescription = this.createDeviceRepresentation((DeviceId)deviceId, config);
            this.log.debug("Connecting NETCONF device {}, on {}:{} with username {}", new Object[]{deviceId, config.ip(), config.port(), config.username()});
            this.storeDeviceKey(config.sshKey(), config.username(), config.password(), (DeviceId)deviceId);
            if (this.deviceService.getDevice(deviceId) == null) {
                this.providerService.deviceConnected(deviceId, deviceDescription);
            }
            try {
                this.checkAndUpdateDevice((DeviceId)deviceId, deviceDescription);
            }
            catch (Exception e) {
                this.log.error("Unhandled exception checking {}", deviceId, (Object)e);
            }
        });
    }

    private void checkAndUpdateDevice(DeviceId deviceId, DeviceDescription deviceDescription) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device == null) {
            this.log.debug("Device {} has not been added to store, since it's not reachable", (Object)deviceId);
        } else {
            boolean isReachable = this.isReachable(deviceId);
            if (isReachable && !this.deviceService.isAvailable(deviceId)) {
                if (device.is(DeviceDescriptionDiscovery.class)) {
                    if (this.mastershipService.isLocalMaster(deviceId)) {
                        DeviceDescriptionDiscovery deviceDescriptionDiscovery = (DeviceDescriptionDiscovery)device.as(DeviceDescriptionDiscovery.class);
                        DeviceDescription updatedDeviceDescription = deviceDescriptionDiscovery.discoverDeviceDetails();
                        if (updatedDeviceDescription != null && !this.descriptionEquals(device, updatedDeviceDescription)) {
                            this.providerService.deviceConnected(deviceId, (DeviceDescription)new DefaultDeviceDescription(updatedDeviceDescription, true, new SparseAnnotations[]{updatedDeviceDescription.annotations()}));
                        } else if (updatedDeviceDescription == null) {
                            this.providerService.deviceConnected(deviceId, (DeviceDescription)new DefaultDeviceDescription(deviceDescription, true, new SparseAnnotations[]{deviceDescription.annotations()}));
                        }
                        if (this.deviceService.getPorts(deviceId).isEmpty()) {
                            this.discoverPorts(deviceId);
                        }
                    }
                } else {
                    this.log.warn("No DeviceDescriptionDiscovery behaviour for device {} using DefaultDeviceDescription", (Object)deviceId);
                    this.providerService.deviceConnected(deviceId, (DeviceDescription)new DefaultDeviceDescription(deviceDescription, true, new SparseAnnotations[]{deviceDescription.annotations()}));
                }
            } else if (!isReachable && this.deviceService.isAvailable(deviceId)) {
                this.providerService.deviceDisconnected(deviceId);
            } else if (isReachable && this.deviceService.isAvailable(deviceId) && this.mastershipService.isLocalMaster(deviceId)) {
                this.updatePortStatistics(device);
            }
        }
    }

    private void updatePortStatistics(Device device) {
        if (device.is(PortStatisticsDiscovery.class)) {
            PortStatisticsDiscovery d = (PortStatisticsDiscovery)device.as(PortStatisticsDiscovery.class);
            Collection portStatistics = d.discoverPortStatistics();
            if (portStatistics != null) {
                this.providerService.updatePortStatistics(device.id(), portStatistics);
            }
        } else {
            this.log.debug("No port statistics getter behaviour for device {}", (Object)device.id());
        }
    }

    private boolean descriptionEquals(Device device, DeviceDescription updatedDeviceDescription) {
        return Objects.equal((Object)device.id().uri(), (Object)updatedDeviceDescription.deviceUri()) && Objects.equal((Object)device.type(), (Object)updatedDeviceDescription.type()) && Objects.equal((Object)device.manufacturer(), (Object)updatedDeviceDescription.manufacturer()) && Objects.equal((Object)device.hwVersion(), (Object)updatedDeviceDescription.hwVersion()) && Objects.equal((Object)device.swVersion(), (Object)updatedDeviceDescription.swVersion()) && Objects.equal((Object)device.serialNumber(), (Object)updatedDeviceDescription.serialNumber()) && Objects.equal((Object)device.chassisId(), (Object)updatedDeviceDescription.chassisId()) && Objects.equal((Object)device.annotations(), (Object)updatedDeviceDescription.annotations());
    }

    private void checkAndUpdateDevices() {
        Set deviceSubjects = this.cfgService.getSubjects(DeviceId.class, NetconfDeviceConfig.class);
        deviceSubjects.forEach(deviceId -> {
            NetconfDeviceConfig config = (NetconfDeviceConfig)this.cfgService.getConfig(deviceId, NetconfDeviceConfig.class);
            DeviceDescription deviceDescription = this.createDeviceRepresentation((DeviceId)deviceId, config);
            this.storeDeviceKey(config.sshKey(), config.username(), config.password(), (DeviceId)deviceId);
            this.checkAndUpdateDevice((DeviceId)deviceId, deviceDescription);
        });
    }

    private DeviceDescription createDeviceRepresentation(DeviceId deviceId, NetconfDeviceConfig config) {
        Preconditions.checkNotNull((Object)deviceId, (Object)ISNULL);
        ChassisId cid = new ChassisId();
        String ipAddress = config.ip().toString();
        DefaultAnnotations annotations = DefaultAnnotations.builder().set(IPADDRESS, ipAddress).set(PORT, String.valueOf(config.port())).set("protocol", "netconf".toUpperCase()).build();
        return new DefaultDeviceDescription(deviceId.uri(), Device.Type.SWITCH, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, cid, false, new SparseAnnotations[]{annotations});
    }

    private void storeDeviceKey(String sshKey, String username, String password, DeviceId deviceId) {
        if (sshKey.equals("")) {
            this.deviceKeyAdminService.addKey(DeviceKey.createDeviceKeyUsingUsernamePassword((DeviceKeyId)DeviceKeyId.deviceKeyId((String)deviceId.toString()), null, (String)username, (String)password));
        } else {
            this.deviceKeyAdminService.addKey(DeviceKey.createDeviceKeyUsingSshKey((DeviceKeyId)DeviceKeyId.deviceKeyId((String)deviceId.toString()), null, (String)username, (String)password, (String)sshKey));
        }
    }

    private void initiateConnection(DeviceId deviceId, MastershipRole newRole) {
        try {
            if (this.isReachable(deviceId)) {
                this.controller.connectDevice(deviceId);
                this.providerService.receivedRoleReply(deviceId, newRole, MastershipRole.MASTER);
            }
        }
        catch (Exception e) {
            if (this.deviceService.getDevice(deviceId) != null) {
                this.providerService.deviceDisconnected(deviceId);
            }
            this.deviceKeyAdminService.removeKey(DeviceKeyId.deviceKeyId((String)deviceId.toString()));
            throw new RuntimeException((Throwable)new NetconfException("Can't connect to NETCONF device " + deviceId, (Throwable)e));
        }
    }

    private void discoverPorts(DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device.is(PortDiscovery.class)) {
            PortDiscovery portConfig = (PortDiscovery)device.as(PortDiscovery.class);
            this.providerService.updatePorts(deviceId, portConfig.getPorts());
        } else if (device.is(DeviceDescriptionDiscovery.class)) {
            DeviceDescriptionDiscovery deviceDescriptionDiscovery = (DeviceDescriptionDiscovery)device.as(DeviceDescriptionDiscovery.class);
            this.providerService.updatePorts(deviceId, deviceDescriptionDiscovery.discoverPortDetails());
        } else {
            this.log.warn("No portGetter behaviour for device {}", (Object)deviceId);
        }
        this.updatePortStatistics(device);
    }

    public DeviceId getDeviceId(String ip, int port) {
        try {
            return DeviceId.deviceId((URI)new URI("netconf", ip + ":" + port, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to build deviceID for device " + ip + ":" + port, e);
        }
    }

    protected void translateConfig() {
        NetconfProviderConfig cfg = (NetconfProviderConfig)this.cfgService.getConfig((Object)this.appId, NetconfProviderConfig.class);
        if (cfg != null) {
            try {
                cfg.getDevicesAddresses().forEach(addr -> {
                    DeviceId deviceId = this.getDeviceId(addr.ip().toString(), addr.port());
                    this.log.info("Translating config for device {}", (Object)deviceId);
                    if (this.cfgService.getConfig((Object)deviceId, NetconfDeviceConfig.class) == null) {
                        ObjectMapper mapper = new ObjectMapper();
                        ObjectNode device = mapper.createObjectNode();
                        device.put("ip", addr.ip().toString());
                        device.put(PORT, addr.port());
                        device.put("username", addr.name());
                        device.put("password", addr.password());
                        device.put("sshkey", addr.sshkey());
                        this.cfgService.applyConfig((Object)deviceId, NetconfDeviceConfig.class, (JsonNode)device);
                    } else {
                        this.log.warn("Config for device {} already exists, ignoring", (Object)deviceId);
                    }
                });
            }
            catch (ConfigException e) {
                this.log.error("Cannot read config error " + (Object)((Object)e));
            }
        }
    }

    protected void bindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.providerRegistry = deviceProviderRegistry;
    }

    protected void unbindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.providerRegistry == deviceProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindController(NetconfController netconfController) {
        this.controller = netconfController;
    }

    protected void unbindController(NetconfController netconfController) {
        if (this.controller == netconfController) {
            this.controller = null;
        }
    }

    protected void bindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgService = networkConfigRegistry;
    }

    protected void unbindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgService == networkConfigRegistry) {
            this.cfgService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindDeviceKeyAdminService(DeviceKeyAdminService deviceKeyAdminService) {
        this.deviceKeyAdminService = deviceKeyAdminService;
    }

    protected void unbindDeviceKeyAdminService(DeviceKeyAdminService deviceKeyAdminService) {
        if (this.deviceKeyAdminService == deviceKeyAdminService) {
            this.deviceKeyAdminService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindComponentConfigService(ComponentConfigService componentConfigService) {
        this.componentConfigService = componentConfigService;
    }

    protected void unbindComponentConfigService(ComponentConfigService componentConfigService) {
        if (this.componentConfigService == componentConfigService) {
            this.componentConfigService = null;
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            if (event.type() == DeviceEvent.Type.DEVICE_ADDED) {
                NetconfDeviceProvider.this.executor.execute(() -> NetconfDeviceProvider.this.discoverPorts(((Device)event.subject()).id()));
            } else if (event.type() == DeviceEvent.Type.DEVICE_REMOVED) {
                NetconfDeviceProvider.this.log.debug("removing device {}", (Object)((Device)event.subject()).id());
                NetconfDeviceProvider.this.controller.disconnectDevice(((Device)event.subject()).id(), true);
            }
        }

        public boolean isRelevant(DeviceEvent event) {
            if (NetconfDeviceProvider.this.mastershipService.getMasterFor(((Device)event.subject()).id()) == null) {
                return true;
            }
            return "netconf".toUpperCase().equals(((Device)event.subject()).annotations().value("protocol")) && NetconfDeviceProvider.this.mastershipService.isLocalMaster(((Device)event.subject()).id());
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.configClass().equals(NetconfDeviceConfig.class)) {
                NetconfDeviceProvider.this.executor.execute(() -> NetconfDeviceProvider.this.connectDevices());
            } else {
                NetconfDeviceProvider.this.log.warn("Injecting device via this Json is deprecated, please put configuration under devices/ as shown in the wiki");
                NetconfDeviceProvider.this.translateConfig();
            }
        }

        public boolean isRelevant(NetworkConfigEvent event) {
            return !(!event.configClass().equals(NetconfDeviceConfig.class) && !event.configClass().equals(NetconfProviderConfig.class) || event.type() != NetworkConfigEvent.Type.CONFIG_ADDED && event.type() != NetworkConfigEvent.Type.CONFIG_UPDATED);
        }
    }

    private class InnerNetconfDeviceListener
    implements NetconfDeviceListener {
        private InnerNetconfDeviceListener() {
        }

        public void deviceAdded(DeviceId deviceId) {
            NetconfDeviceProvider.this.log.debug("Netconf device {} added to Netconf subController", (Object)deviceId);
        }

        public void deviceRemoved(DeviceId deviceId) {
            Preconditions.checkNotNull((Object)deviceId, (Object)NetconfDeviceProvider.ISNULL);
            if (NetconfDeviceProvider.this.deviceService.getDevice(deviceId) != null) {
                NetconfDeviceProvider.this.providerService.deviceDisconnected(deviceId);
                NetconfDeviceProvider.this.log.debug("Netconf device {} removed from Netconf subController", (Object)deviceId);
            } else {
                NetconfDeviceProvider.this.log.warn("Netconf device {} does not exist in the store, it may already have been removed", (Object)deviceId);
            }
        }
    }
}

