/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.netconf.device.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.tuple.Pair;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.Config;

@Beta
public class NetconfDeviceConfig
extends Config<DeviceId> {
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String SSHKEY = "sshkey";

    public boolean isValid() {
        return this.hasOnlyFields(new String[]{IP, PORT, USERNAME, PASSWORD, SSHKEY}) && this.ip() != null;
    }

    public IpAddress ip() {
        return IpAddress.valueOf((String)this.get(IP, (String)((Pair)Preconditions.checkNotNull(this.extractIpPort())).getKey()));
    }

    public int port() {
        return this.get(PORT, (Integer)((Pair)Preconditions.checkNotNull(this.extractIpPort())).getValue());
    }

    public String username() {
        return this.get(USERNAME, "");
    }

    public String password() {
        return this.get(PASSWORD, "");
    }

    public String sshKey() {
        return this.get(SSHKEY, "");
    }

    public NetconfDeviceConfig setIp(String ip) {
        return (NetconfDeviceConfig)this.setOrClear(IP, ip);
    }

    public NetconfDeviceConfig setPort(int port) {
        return (NetconfDeviceConfig)this.setOrClear(PORT, port);
    }

    public NetconfDeviceConfig setUsername(String username) {
        return (NetconfDeviceConfig)this.setOrClear(USERNAME, username);
    }

    public NetconfDeviceConfig setPassword(String password) {
        return (NetconfDeviceConfig)this.setOrClear(PASSWORD, password);
    }

    public NetconfDeviceConfig setSshKey(String sshKey) {
        return (NetconfDeviceConfig)this.setOrClear(SSHKEY, sshKey);
    }

    private Pair<String, Integer> extractIpPort() {
        String info = ((DeviceId)this.subject).toString();
        if (info.startsWith("netconf")) {
            String ip = info.substring(info.indexOf(":") + 1, info.lastIndexOf(":"));
            int port = Integer.parseInt(info.substring(info.lastIndexOf(":") + 1));
            return Pair.of((Object)ip, (Object)port);
        }
        return null;
    }
}

