/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerHolder;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;

public abstract class AbstractIoServiceFactory
extends AbstractCloseable
implements IoServiceFactory,
FactoryManagerHolder,
ExecutorServiceCarrier {
    private final FactoryManager manager;
    private final ExecutorService executor;
    private final boolean shutdownExecutor;

    protected AbstractIoServiceFactory(FactoryManager factoryManager, ExecutorService executorService, boolean shutdownOnExit) {
        this.manager = factoryManager;
        this.executor = executorService;
        this.shutdownExecutor = shutdownOnExit;
    }

    @Override
    public final FactoryManager getFactoryManager() {
        return this.manager;
    }

    @Override
    public final ExecutorService getExecutorService() {
        return this.executor;
    }

    @Override
    public final boolean isShutdownOnExit() {
        return this.shutdownExecutor;
    }

    @Override
    protected void doCloseImmediately() {
        try {
            ExecutorService service = this.getExecutorService();
            if (service != null && this.isShutdownOnExit() && !service.isShutdown()) {
                this.log.debug("Shutdown executor");
                service.shutdownNow();
                if (service.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.log.debug("Shutdown complete");
                } else {
                    this.log.debug("Not all tasks terminated");
                }
            }
        }
        catch (Exception e) {
            this.log.debug("Exception caught while closing executor", (Throwable)e);
        }
        finally {
            super.doCloseImmediately();
        }
    }

    public static int getNioWorkers(FactoryManager manager) {
        int nb = PropertyResolverUtils.getIntProperty(manager, "nio-workers", FactoryManager.DEFAULT_NIO_WORKERS);
        if (nb > 0) {
            return nb;
        }
        return FactoryManager.DEFAULT_NIO_WORKERS;
    }
}

