/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.io.IoUtils;

public class DefaultKnownHostsServerKeyVerifier
extends KnownHostsServerKeyVerifier {
    private final boolean strict;

    public DefaultKnownHostsServerKeyVerifier(ServerKeyVerifier delegate) {
        this(delegate, true);
    }

    public DefaultKnownHostsServerKeyVerifier(ServerKeyVerifier delegate, boolean strict) {
        this(delegate, strict, KnownHostEntry.getDefaultKnownHostsFile(), IoUtils.getLinkOptions(false));
    }

    public DefaultKnownHostsServerKeyVerifier(ServerKeyVerifier delegate, boolean strict, File file) {
        this(delegate, strict, Objects.requireNonNull(file, "No file provided").toPath(), IoUtils.getLinkOptions(false));
    }

    public DefaultKnownHostsServerKeyVerifier(ServerKeyVerifier delegate, boolean strict, Path file, LinkOption ... options) {
        super(delegate, file, options);
        this.strict = strict;
    }

    public final boolean isStrict() {
        return this.strict;
    }

    @Override
    protected List<KnownHostsServerKeyVerifier.HostEntryPair> reloadKnownHosts(Path file) throws IOException, GeneralSecurityException {
        if (this.isStrict()) {
            Pair<String, Object> violation;
            if (this.log.isDebugEnabled()) {
                this.log.debug("reloadKnownHosts({}) check permissions", (Object)file);
            }
            if ((violation = DefaultKnownHostsServerKeyVerifier.validateStrictConfigFilePermissions(file, new LinkOption[0])) != null) {
                this.log.warn("reloadKnownHosts({}) invalid file permissions: {}", (Object)file, (Object)violation.getFirst());
                this.updateReloadAttributes();
                return Collections.emptyList();
            }
        }
        return super.reloadKnownHosts(file);
    }
}

