/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.apache.sshd.client.config.hosts.KnownHostDigest;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class KnownHostHashValue {
    public static final char HASHED_HOST_DELIMITER = '|';
    public static final NamedFactory<Mac> DEFAULT_DIGEST = KnownHostDigest.SHA1;
    private NamedFactory<Mac> digester = DEFAULT_DIGEST;
    private byte[] saltValue;
    private byte[] digestValue;

    public NamedFactory<Mac> getDigester() {
        return this.digester;
    }

    public void setDigester(NamedFactory<Mac> digester) {
        this.digester = digester;
    }

    public byte[] getSaltValue() {
        return this.saltValue;
    }

    public void setSaltValue(byte[] saltValue) {
        this.saltValue = saltValue;
    }

    public byte[] getDigestValue() {
        return this.digestValue;
    }

    public void setDigestValue(byte[] digestValue) {
        this.digestValue = digestValue;
    }

    public boolean isHostMatch(String host) {
        if (GenericUtils.isEmpty(host)) {
            return false;
        }
        try {
            byte[] expected = this.getDigestValue();
            byte[] actual = KnownHostHashValue.calculateHashValue(host, this.getDigester(), this.getSaltValue());
            return Arrays.equals(expected, actual);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeSshException("Failed (" + t.getClass().getSimpleName() + ")" + " to calculate hash value: " + t.getMessage(), t);
        }
    }

    public String toString() {
        if (this.getDigester() == null || NumberUtils.isEmpty(this.getSaltValue()) || NumberUtils.isEmpty(this.getDigestValue())) {
            return Objects.toString(this.getDigester(), null) + "-" + BufferUtils.toHex(':', this.getSaltValue()) + "-" + BufferUtils.toHex(':', this.getDigestValue());
        }
        try {
            return KnownHostHashValue.append(new StringBuilder(127), this).toString();
        }
        catch (IOException | RuntimeException e) {
            return e.getClass().getSimpleName() + ": " + e.getMessage();
        }
    }

    public static byte[] calculateHashValue(String host, Factory<? extends Mac> factory, byte[] salt) throws Exception {
        return KnownHostHashValue.calculateHashValue(host, factory.create(), salt);
    }

    public static byte[] calculateHashValue(String host, Mac mac, byte[] salt) throws Exception {
        mac.init(salt);
        byte[] hostBytes = host.getBytes(StandardCharsets.UTF_8);
        mac.update(hostBytes);
        return mac.doFinal();
    }

    public static <A extends Appendable> A append(A sb, KnownHostHashValue hashValue) throws IOException {
        return hashValue == null ? sb : KnownHostHashValue.append(sb, hashValue.getDigester(), hashValue.getSaltValue(), hashValue.getDigestValue());
    }

    public static <A extends Appendable> A append(A sb, NamedResource factory, byte[] salt, byte[] digest) throws IOException {
        Base64.Encoder encoder = Base64.getEncoder();
        sb.append('|').append(factory.getName());
        sb.append('|').append(encoder.encodeToString(salt));
        sb.append('|').append(encoder.encodeToString(digest));
        return sb;
    }

    public static KnownHostHashValue parse(String pattern) {
        return KnownHostHashValue.parse(pattern, GenericUtils.isEmpty(pattern) ? null : new KnownHostHashValue());
    }

    public static <V extends KnownHostHashValue> V parse(String pattern, V value) {
        if (GenericUtils.isEmpty(pattern)) {
            return value;
        }
        String[] components = GenericUtils.split(pattern, '|');
        ValidateUtils.checkTrue(components.length == 4, "Invalid hash pattern (insufficient data): %s", (Object)pattern);
        ValidateUtils.checkTrue(GenericUtils.isEmpty(components[0]), "Invalid hash pattern (unexpected extra data): %s", (Object)pattern);
        NamedFactory factory = ValidateUtils.checkNotNull(KnownHostDigest.fromName(components[1]), "Invalid hash pattern (unknown digest): %s", (Object)pattern);
        Base64.Decoder decoder = Base64.getDecoder();
        value.setDigester(factory);
        value.setSaltValue(decoder.decode(components[2]));
        value.setDigestValue(decoder.decode(components[3]));
        return value;
    }
}

