/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.io.IOException;
import java.nio.channels.Channel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.auth.pubkey.AbstractKeyPairIterator;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.client.auth.pubkey.SessionKeyPairIterator;
import org.apache.sshd.client.auth.pubkey.SshAgentPublicKeyIterator;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;

public class UserAuthPublicKeyIterator
extends AbstractKeyPairIterator<PublicKeyIdentity>
implements Channel {
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final Iterator<Iterator<? extends PublicKeyIdentity>> iterators;
    private Iterator<? extends PublicKeyIdentity> current;
    private SshAgent agent;

    public UserAuthPublicKeyIterator(ClientSession session, SignatureFactoriesManager signatureFactories) throws Exception {
        super(session);
        LinkedList<AbstractKeyPairIterator> identities = new LinkedList<AbstractKeyPairIterator>();
        identities.add(new SessionKeyPairIterator(session, signatureFactories, KeyIdentityProvider.iteratorOf(session)));
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No session factory manager");
        SshAgentFactory factory = manager.getAgentFactory();
        if (factory != null) {
            try {
                this.agent = Objects.requireNonNull(factory.createClient(manager), "No agent created");
                identities.add(new SshAgentPublicKeyIterator(session, this.agent));
            }
            catch (Exception e) {
                try {
                    this.closeAgent();
                }
                catch (Exception err) {
                    e.addSuppressed(err);
                }
                throw e;
            }
        }
        this.iterators = GenericUtils.iteratorOf(identities);
        this.current = this.nextIterator(this.iterators);
    }

    @Override
    public boolean hasNext() {
        if (!this.isOpen()) {
            return false;
        }
        return this.current != null;
    }

    @Override
    public PublicKeyIdentity next() {
        if (!this.isOpen()) {
            throw new NoSuchElementException("Iterator is closed");
        }
        PublicKeyIdentity pki = this.current.next();
        if (!this.current.hasNext()) {
            this.current = this.nextIterator(this.iterators);
        }
        return pki;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            this.closeAgent();
        }
    }

    protected void closeAgent() throws IOException {
        if (this.agent != null) {
            try {
                this.agent.close();
            }
            finally {
                this.agent = null;
            }
        }
    }

    protected Iterator<? extends PublicKeyIdentity> nextIterator(Iterator<? extends Iterator<? extends PublicKeyIdentity>> available) {
        while (available != null && available.hasNext()) {
            Iterator<? extends PublicKeyIdentity> iter = available.next();
            if (!iter.hasNext()) continue;
            return iter;
        }
        return null;
    }
}

