/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ofagent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.BoundedThreadPool;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkEvent;
import org.onosproject.incubator.net.virtual.VirtualNetworkListener;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.flow.FlowRuleListener;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.ofagent.api.OFAgent;
import org.onosproject.ofagent.api.OFAgentEvent;
import org.onosproject.ofagent.api.OFAgentListener;
import org.onosproject.ofagent.api.OFAgentService;
import org.onosproject.ofagent.api.OFController;
import org.onosproject.ofagent.api.OFSwitch;
import org.onosproject.ofagent.api.OFSwitchCapabilities;
import org.onosproject.ofagent.api.OFSwitchService;
import org.onosproject.ofagent.impl.DefaultOFSwitch;
import org.onosproject.ofagent.impl.DefaultOFSwitchCapabilities;
import org.onosproject.ofagent.impl.OFConnectionHandler;
import org.projectfloodlight.openflow.types.DatapathId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class OFSwitchManager
implements OFSwitchService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final OFSwitchCapabilities DEFAULT_CAPABILITIES = DefaultOFSwitchCapabilities.builder().flowStats().tableStats().portStats().groupStats().queueStats().ipReasm().portBlocked().build();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualNetworkService virtualNetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OFAgentService ofAgentService;
    private final ConcurrentHashMap<DeviceId, OFSwitch> ofSwitchMap = new ConcurrentHashMap();
    private final ExecutorService eventExecutor = BoundedThreadPool.newSingleThreadExecutor((ThreadFactory)Tools.groupedThreads((String)this.getClass().getSimpleName(), (String)"event-handler", (Logger)this.log));
    private final OFAgentListener ofAgentListener = new InternalOFAgentListener();
    private final VirtualNetworkListener vNetworkListener = new InternalVirtualNetworkListener();
    private final DeviceListener deviceListener = new InternalDeviceListener();
    private final FlowRuleListener flowRuleListener = new InternalFlowRuleListener();
    private final PacketProcessor packetProcessor = new InternalPacketProcessor();
    private NioEventLoopGroup ioWorker;
    private ApplicationId appId;
    private NodeId localId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.ofagent");
        this.localId = this.clusterService.getLocalNode().id();
        this.ioWorker = new NioEventLoopGroup();
        this.ofAgentService.agents().forEach(this::processOFAgentCreated);
        this.ofAgentService.addListener(this.ofAgentListener);
        this.virtualNetService.addListener((EventListener)this.vNetworkListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.virtualNetService.removeListener((EventListener)this.vNetworkListener);
        this.ofAgentService.removeListener(this.ofAgentListener);
        this.ofAgentService.agents().forEach(this::processOFAgentStopped);
        this.ioWorker.shutdownGracefully();
        this.eventExecutor.shutdown();
        this.log.info("Stopped");
    }

    @Override
    public Set<OFSwitch> ofSwitches() {
        return ImmutableSet.copyOf(this.ofSwitchMap.values());
    }

    @Override
    public Set<OFSwitch> ofSwitches(NetworkId networkId) {
        Set ofSwitches = this.devices(networkId).stream().map(this.ofSwitchMap::get).filter(Objects::nonNull).collect(Collectors.toSet());
        return ImmutableSet.copyOf(ofSwitches);
    }

    private void addOFSwitch(NetworkId networkId, DeviceId deviceId) {
        DefaultOFSwitch ofSwitch = DefaultOFSwitch.of(this.dpidWithDeviceId(deviceId), DEFAULT_CAPABILITIES);
        this.ofSwitchMap.put(deviceId, ofSwitch);
        this.log.info("Added virtual OF switch for {}", (Object)deviceId);
        OFAgent ofAgent = this.ofAgentService.agent(networkId);
        if (ofAgent.state() == OFAgent.State.STARTED) {
            this.connectController(ofSwitch, ofAgent.controllers());
        }
    }

    private void deleteOFSwitch(DeviceId deviceId) {
        OFSwitch ofSwitch = this.ofSwitchMap.get(deviceId);
        ofSwitch.controllerChannels().forEach(ChannelOutboundInvoker::disconnect);
        this.ofSwitchMap.remove(deviceId);
        this.log.info("Removed virtual OFSwitch for {}", (Object)deviceId);
    }

    private void connectController(OFSwitch ofSwitch, Set<OFController> controllers) {
        controllers.forEach(controller -> {
            OFConnectionHandler connectionHandler = new OFConnectionHandler(ofSwitch, (OFController)controller, (EventLoopGroup)this.ioWorker);
            connectionHandler.connect();
        });
    }

    private void disconnectController(OFSwitch ofSwitch, Set<OFController> controllers) {
        Set controllerAddrs = controllers.stream().map(ctrl -> new InetSocketAddress(ctrl.ip().toInetAddress(), ctrl.port().toInt())).collect(Collectors.toSet());
        ofSwitch.controllerChannels().stream().filter(channel -> controllerAddrs.contains(channel.remoteAddress())).forEach(ChannelOutboundInvoker::disconnect);
    }

    private Set<DeviceId> devices(NetworkId networkId) {
        Set deviceIds = this.virtualNetService.getVirtualDevices(networkId).stream().map(Device::id).collect(Collectors.toSet());
        return ImmutableSet.copyOf(deviceIds);
    }

    private DatapathId dpidWithDeviceId(DeviceId deviceId) {
        String strDeviceId = deviceId.toString().split(":")[1];
        Preconditions.checkArgument((strDeviceId.length() == 16 ? 1 : 0) != 0, (Object)("Invalid device ID " + strDeviceId));
        String resultedHexString = "";
        for (int i = 0; i < 8; ++i) {
            resultedHexString = resultedHexString + strDeviceId.charAt(2 * i) + strDeviceId.charAt(2 * i + 1);
            if (i == 7) continue;
            resultedHexString = resultedHexString + ":";
        }
        return DatapathId.of((String)resultedHexString);
    }

    private void processOFAgentCreated(OFAgent ofAgent) {
        this.devices(ofAgent.networkId()).forEach(deviceId -> this.addOFSwitch(ofAgent.networkId(), (DeviceId)deviceId));
    }

    private void processOFAgentRemoved(OFAgent ofAgent) {
        this.devices(ofAgent.networkId()).forEach(this::deleteOFSwitch);
    }

    private void processOFAgentStarted(OFAgent ofAgent) {
        this.devices(ofAgent.networkId()).forEach(deviceId -> {
            OFSwitch ofSwitch = this.ofSwitchMap.get(deviceId);
            if (ofSwitch != null) {
                this.connectController(ofSwitch, ofAgent.controllers());
            }
        });
        DeviceService deviceService = (DeviceService)this.virtualNetService.get(ofAgent.networkId(), DeviceService.class);
        deviceService.addListener((EventListener)this.deviceListener);
        PacketService packetService = (PacketService)this.virtualNetService.get(ofAgent.networkId(), PacketService.class);
        packetService.addProcessor(this.packetProcessor, PacketProcessor.director((int)0));
        FlowRuleService flowRuleService = (FlowRuleService)this.virtualNetService.get(ofAgent.networkId(), FlowRuleService.class);
        flowRuleService.addListener((EventListener)this.flowRuleListener);
    }

    private void processOFAgentStopped(OFAgent ofAgent) {
        this.devices(ofAgent.networkId()).forEach(deviceId -> {
            OFSwitch ofSwitch = this.ofSwitchMap.get(deviceId);
            if (ofSwitch != null) {
                this.disconnectController(ofSwitch, ofAgent.controllers());
            }
        });
        DeviceService deviceService = (DeviceService)this.virtualNetService.get(ofAgent.networkId(), DeviceService.class);
        deviceService.removeListener((EventListener)this.deviceListener);
        PacketService packetService = (PacketService)this.virtualNetService.get(ofAgent.networkId(), PacketService.class);
        packetService.removeProcessor(this.packetProcessor);
        FlowRuleService flowRuleService = (FlowRuleService)this.virtualNetService.get(ofAgent.networkId(), FlowRuleService.class);
        flowRuleService.removeListener((EventListener)this.flowRuleListener);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindVirtualNetService(VirtualNetworkService virtualNetworkService) {
        this.virtualNetService = virtualNetworkService;
    }

    protected void unbindVirtualNetService(VirtualNetworkService virtualNetworkService) {
        if (this.virtualNetService == virtualNetworkService) {
            this.virtualNetService = null;
        }
    }

    protected void bindOfAgentService(OFAgentService oFAgentService) {
        this.ofAgentService = oFAgentService;
    }

    protected void unbindOfAgentService(OFAgentService oFAgentService) {
        if (this.ofAgentService == oFAgentService) {
            this.ofAgentService = null;
        }
    }

    private class InternalFlowRuleListener
    implements FlowRuleListener {
        private InternalFlowRuleListener() {
        }

        public void event(FlowRuleEvent event) {
        }
    }

    private class InternalPacketProcessor
    implements PacketProcessor {
        private InternalPacketProcessor() {
        }

        public void process(PacketContext context) {
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            switch ((DeviceEvent.Type)event.type()) {
                default: 
            }
        }
    }

    private class InternalOFAgentListener
    implements OFAgentListener {
        private InternalOFAgentListener() {
        }

        public boolean isRelevant(OFAgentEvent event) {
            return Objects.equals(OFSwitchManager.this.localId, OFSwitchManager.this.leadershipService.getLeader(OFSwitchManager.this.appId.name()));
        }

        public void event(OFAgentEvent event) {
            switch ((OFAgentEvent.Type)event.type()) {
                case OFAGENT_CREATED: {
                    OFSwitchManager.this.eventExecutor.execute(() -> {
                        OFAgent ofAgent = (OFAgent)event.subject();
                        OFSwitchManager.this.log.debug("Processing OFAgent created: {}", (Object)ofAgent);
                        OFSwitchManager.this.processOFAgentCreated(ofAgent);
                    });
                    break;
                }
                case OFAGENT_REMOVED: {
                    OFSwitchManager.this.eventExecutor.execute(() -> {
                        OFAgent ofAgent = (OFAgent)event.subject();
                        OFSwitchManager.this.log.debug("Processing OFAgent removed: {}", (Object)ofAgent);
                        OFSwitchManager.this.processOFAgentRemoved(ofAgent);
                    });
                    break;
                }
                case OFAGENT_CONTROLLER_ADDED: {
                    break;
                }
                case OFAGENT_CONTROLLER_REMOVED: {
                    break;
                }
                case OFAGENT_STARTED: {
                    OFSwitchManager.this.eventExecutor.execute(() -> {
                        OFAgent ofAgent = (OFAgent)event.subject();
                        OFSwitchManager.this.log.debug("Processing OFAgent started: {}", (Object)ofAgent);
                        OFSwitchManager.this.processOFAgentStarted(ofAgent);
                    });
                    break;
                }
                case OFAGENT_STOPPED: {
                    OFSwitchManager.this.eventExecutor.execute(() -> {
                        OFAgent ofAgent = (OFAgent)event.subject();
                        OFSwitchManager.this.log.debug("Processing OFAgent stopped: {}", (Object)ofAgent);
                        OFSwitchManager.this.processOFAgentStopped(ofAgent);
                    });
                    break;
                }
            }
        }
    }

    private class InternalVirtualNetworkListener
    implements VirtualNetworkListener {
        private InternalVirtualNetworkListener() {
        }

        public void event(VirtualNetworkEvent event) {
            switch ((VirtualNetworkEvent.Type)event.type()) {
                case VIRTUAL_DEVICE_ADDED: {
                    OFSwitchManager.this.eventExecutor.execute(() -> {
                        OFSwitchManager.this.log.debug("Virtual device {} added to network {}", (Object)event.virtualDevice().id(), event.subject());
                        OFSwitchManager.this.addOFSwitch((NetworkId)event.subject(), event.virtualDevice().id());
                    });
                    break;
                }
                case VIRTUAL_DEVICE_UPDATED: {
                    break;
                }
                case VIRTUAL_DEVICE_REMOVED: {
                    OFSwitchManager.this.eventExecutor.execute(() -> {
                        OFSwitchManager.this.log.debug("Virtual device {} removed from network {}", (Object)event.virtualDevice().id(), event.subject());
                        OFSwitchManager.this.deleteOFSwitch(event.virtualDevice().id());
                    });
                    break;
                }
            }
        }
    }
}

