/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ofagent.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.onosproject.ofagent.api.OFController;
import org.onosproject.ofagent.api.OFSwitch;
import org.onosproject.ofagent.impl.OFChannelInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OFConnectionHandler
implements ChannelFutureListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MSG_STATE = "Device %s %s to controller %s:%s";
    private static final String MSG_CONNECTING = "connecting";
    private static final String MSG_CONNECTED = "connected";
    private static final String MSG_FAILED = "failed to connect";
    private final AtomicInteger retryCount;
    private final OFSwitch ofSwitch;
    private final OFController controller;
    private final EventLoopGroup workGroup;
    private static final int MAX_RETRY = 3;

    public OFConnectionHandler(OFSwitch ofSwitch, OFController controller, EventLoopGroup workGroup) {
        this.ofSwitch = ofSwitch;
        this.controller = controller;
        this.workGroup = workGroup;
        this.retryCount = new AtomicInteger();
    }

    public void connect() {
        InetSocketAddress remoteAddr = new InetSocketAddress(this.controller.ip().toInetAddress(), this.controller.port().toInt());
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.workGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new OFChannelInitializer(this.ofSwitch));
        this.log.debug(String.format(MSG_STATE, this.ofSwitch.dpid(), MSG_CONNECTING, this.controller.ip(), this.controller.port()));
        bootstrap.connect((SocketAddress)remoteAddr).addListener((GenericFutureListener)this);
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (future.isSuccess()) {
            this.log.info(String.format(MSG_STATE, this.ofSwitch.dpid(), MSG_CONNECTED, this.controller.ip(), this.controller.port()));
        } else if (this.retryCount.getAndIncrement() > 3) {
            this.log.warn(String.format(MSG_STATE, this.ofSwitch.dpid(), MSG_FAILED, this.controller.ip(), this.controller.port()));
        } else {
            EventLoop loop = future.channel().eventLoop();
            loop.schedule(this::connect, 1L, TimeUnit.SECONDS);
        }
    }
}

