/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ofagent.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.RejectedExecutionException;
import org.onosproject.ofagent.api.OFSwitch;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OFChannelHandler
extends ChannelDuplexHandler {
    private static final String MSG_CHANNEL_STATE = "Set channel(%s) state: %s";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final OFSwitch ofSwitch;
    private Channel channel;
    private ChannelState state;

    public OFChannelHandler(OFSwitch ofSwitch) {
        this.ofSwitch = ofSwitch;
        this.setState(ChannelState.INIT);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channel = ctx.channel();
        this.ofSwitch.addControllerChannel(this.channel);
        try {
            this.ofSwitch.sendOfHello(this.channel);
            this.log.trace("Send OF_13 Hello to {}", (Object)this.channel.remoteAddress());
            this.setState(ChannelState.WAIT_HELLO);
        }
        catch (Exception ex) {
            this.log.error("Failed sending OF_13 Hello to {} for {}", (Object)this.channel.remoteAddress(), (Object)ex.getMessage());
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.ofSwitch.deleteControllerChannel(this.channel);
        this.log.info("Device {} disconnected from controller {}", (Object)this.ofSwitch.dpid(), (Object)this.channel.remoteAddress());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            this.state.processOFMessage(this, (OFMessage)msg);
        }
        catch (Exception ex) {
            ctx.fireExceptionCaught((Throwable)ex);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof ReadTimeoutException) {
            this.log.error("Connection closed because of ReadTimeoutException {}", (Object)cause.getMessage());
        } else {
            if (cause instanceof ClosedChannelException) {
                this.log.error("ClosedChannelException occurred");
                return;
            }
            if (cause instanceof RejectedExecutionException) {
                this.log.error("Could not process message: queue full");
            } else if (cause instanceof IOException) {
                this.log.error("IOException occurred");
            } else {
                this.log.error("Error while processing message from switch {}", (Object)cause.getMessage());
            }
        }
        this.channel.close();
    }

    private void setState(ChannelState state) {
        this.state = state;
        if (state != ChannelState.INIT) {
            this.log.debug(String.format(MSG_CHANNEL_STATE, this.channel.remoteAddress(), state.name()));
        }
    }

    private void logErrorClose(OFErrorMsg errorMsg) {
        this.log.error("{} from switch {} in state {}", new Object[]{errorMsg, this.ofSwitch.dpid(), this.state});
        this.channel.close();
    }

    private void illegalMessageReceived(OFMessage ofMessage) {
        this.log.warn("Controller should never send this message {} in current state {}", (Object)ofMessage.getType(), (Object)this.state);
    }

    private void unhandledMessageReceived(OFMessage ofMessage) {
        this.log.warn("Unexpected message {} received in state {}", (Object)ofMessage.getType(), (Object)this.state);
    }

    static enum ChannelState {
        INIT{

            @Override
            void processOFMessage(OFChannelHandler handler, OFMessage msg) {
            }
        }
        ,
        WAIT_HELLO{

            @Override
            void processOFMessage(OFChannelHandler handler, OFMessage msg) {
                switch (msg.getType()) {
                    case HELLO: {
                        handler.setState(WAIT_FEATURE_REQUEST);
                        break;
                    }
                    default: {
                        handler.illegalMessageReceived(msg);
                    }
                }
            }
        }
        ,
        WAIT_FEATURE_REQUEST{

            @Override
            void processOFMessage(OFChannelHandler handler, OFMessage msg) {
                switch (msg.getType()) {
                    case FEATURES_REQUEST: {
                        handler.ofSwitch.processFeaturesRequest(handler.channel, msg);
                        handler.setState(ESTABLISHED);
                        break;
                    }
                    case ECHO_REQUEST: {
                        handler.ofSwitch.processEchoRequest(handler.channel, msg);
                        break;
                    }
                    case ERROR: {
                        handler.logErrorClose((OFErrorMsg)msg);
                        break;
                    }
                    default: {
                        handler.illegalMessageReceived(msg);
                    }
                }
            }
        }
        ,
        ESTABLISHED{

            @Override
            void processOFMessage(OFChannelHandler handler, OFMessage msg) {
                switch (msg.getType()) {
                    case STATS_REQUEST: {
                        break;
                    }
                    case SET_CONFIG: {
                        break;
                    }
                    case GET_CONFIG_REQUEST: {
                        break;
                    }
                    case BARRIER_REQUEST: {
                        break;
                    }
                    case ECHO_REQUEST: {
                        handler.ofSwitch.processEchoRequest(handler.channel, msg);
                        break;
                    }
                    case ERROR: {
                        handler.logErrorClose((OFErrorMsg)msg);
                        break;
                    }
                    default: {
                        handler.unhandledMessageReceived(msg);
                    }
                }
            }
        };


        abstract void processOFMessage(OFChannelHandler var1, OFMessage var2);
    }
}

