/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ofagent.impl;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.BoundedThreadPool;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkEvent;
import org.onosproject.incubator.net.virtual.VirtualNetworkListener;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.ofagent.api.OFAgent;
import org.onosproject.ofagent.api.OFAgentAdminService;
import org.onosproject.ofagent.api.OFAgentEvent;
import org.onosproject.ofagent.api.OFAgentListener;
import org.onosproject.ofagent.api.OFAgentService;
import org.onosproject.ofagent.api.OFAgentStore;
import org.onosproject.ofagent.api.OFAgentStoreDelegate;
import org.onosproject.ofagent.impl.DefaultOFAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class OFAgentManager
extends ListenerRegistry<OFAgentEvent, OFAgentListener>
implements OFAgentService,
OFAgentAdminService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MSG_OFAGENT = "OFAgent for network %s %s";
    private static final String MSG_CREATED = "created";
    private static final String MSG_UPDATED = "updated";
    private static final String MSG_REMOVED = "removed";
    private static final String MSG_STARTED = "started";
    private static final String MSG_STOPPED = "stopped";
    private static final String MSG_IN_STARTED = "is already in active state, do nothing";
    private static final String MSG_IN_STOPPED = "is already in inactive state, do nothing";
    private static final String ERR_NULL_OFAGENT = "OFAgent cannot be null";
    private static final String ERR_NULL_NETID = "Network ID cannot be null";
    private static final String ERR_NOT_EXIST = "does not exist";
    private static final String ERR_IN_USE = "is in start state, stop the agent first";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualNetworkService virtualNetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OFAgentStore ofAgentStore;
    private final ExecutorService eventExecutor = BoundedThreadPool.newSingleThreadExecutor((ThreadFactory)Tools.groupedThreads((String)this.getClass().getSimpleName(), (String)"event-handler", (Logger)this.log));
    private final LeadershipEventListener leadershipListener = new InternalLeadershipListener();
    private final VirtualNetworkListener virtualNetListener = new InternalVirtualNetworkListener();
    private final OFAgentStoreDelegate delegate = new InternalOFAgentStoreDelegate();
    private ApplicationId appId;
    private NodeId localId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.ofagent");
        this.localId = this.clusterService.getLocalNode().id();
        this.leadershipService.runForLeadership(this.appId.name());
        this.ofAgentStore.setDelegate(this.delegate);
        this.virtualNetService.addListener((EventListener)this.virtualNetListener);
        this.leadershipService.addListener((EventListener)this.leadershipListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.leadershipService.removeListener((EventListener)this.leadershipListener);
        this.virtualNetService.removeListener((EventListener)this.virtualNetListener);
        this.ofAgentStore.unsetDelegate(this.delegate);
        this.ofAgentStore.ofAgents().stream().filter(ofAgent -> ofAgent.state() == OFAgent.State.STARTED).forEach(ofAgent -> this.stopAgent(ofAgent.networkId()));
        this.eventExecutor.shutdown();
        this.leadershipService.withdraw(this.appId.name());
        this.log.info("Stopped");
    }

    @Override
    public void createAgent(OFAgent ofAgent) {
        Preconditions.checkNotNull((Object)ofAgent, (Object)ERR_NULL_OFAGENT);
        if (ofAgent.state() == OFAgent.State.STARTED) {
            this.log.warn(String.format(MSG_OFAGENT, ofAgent.networkId(), ERR_IN_USE));
            return;
        }
        this.ofAgentStore.createOfAgent(ofAgent);
        this.log.info(String.format(MSG_OFAGENT, ofAgent.networkId(), MSG_CREATED));
    }

    @Override
    public void updateAgent(OFAgent ofAgent) {
        Preconditions.checkNotNull((Object)ofAgent, (Object)ERR_NULL_OFAGENT);
        this.ofAgentStore.updateOfAgent(ofAgent);
        this.log.info(String.format(MSG_OFAGENT, ofAgent.networkId(), MSG_UPDATED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OFAgent removeAgent(NetworkId networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)ERR_NULL_NETID);
        OFAgentManager oFAgentManager = this;
        synchronized (oFAgentManager) {
            OFAgent existing = this.ofAgentStore.ofAgent(networkId);
            if (existing == null) {
                String error = String.format(MSG_OFAGENT, networkId, ERR_NOT_EXIST);
                throw new IllegalStateException(error);
            }
            if (existing.state() == OFAgent.State.STARTED) {
                String error = String.format(MSG_OFAGENT, networkId, ERR_IN_USE);
                throw new IllegalStateException(error);
            }
            this.log.info(String.format(MSG_OFAGENT, networkId, MSG_REMOVED));
            return this.ofAgentStore.removeOfAgent(networkId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAgent(NetworkId networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)ERR_NULL_NETID);
        OFAgentManager oFAgentManager = this;
        synchronized (oFAgentManager) {
            OFAgent existing = this.ofAgentStore.ofAgent(networkId);
            if (existing == null) {
                String error = String.format(MSG_OFAGENT, networkId, ERR_NOT_EXIST);
                throw new IllegalStateException(error);
            }
            if (existing.state() == OFAgent.State.STARTED) {
                String error = String.format(MSG_OFAGENT, networkId, MSG_IN_STARTED);
                throw new IllegalStateException(error);
            }
            OFAgent updated = DefaultOFAgent.builder().from(existing).state(OFAgent.State.STARTED).build();
            this.ofAgentStore.updateOfAgent(updated);
            this.log.info(String.format(MSG_OFAGENT, networkId, MSG_STARTED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAgent(NetworkId networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)ERR_NULL_NETID);
        OFAgentManager oFAgentManager = this;
        synchronized (oFAgentManager) {
            OFAgent existing = this.ofAgentStore.ofAgent(networkId);
            if (existing == null) {
                String error = String.format(MSG_OFAGENT, networkId, ERR_NOT_EXIST);
                throw new IllegalStateException(error);
            }
            if (existing.state() == OFAgent.State.STOPPED) {
                String error = String.format(MSG_OFAGENT, networkId, MSG_IN_STOPPED);
                throw new IllegalStateException(error);
            }
            OFAgent updated = DefaultOFAgent.builder().from(existing).state(OFAgent.State.STOPPED).build();
            this.ofAgentStore.updateOfAgent(updated);
            this.log.info(String.format(MSG_OFAGENT, networkId, MSG_STOPPED));
        }
    }

    @Override
    public Set<OFAgent> agents() {
        return this.ofAgentStore.ofAgents();
    }

    @Override
    public OFAgent agent(NetworkId networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)ERR_NULL_NETID);
        return this.ofAgentStore.ofAgent(networkId);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindVirtualNetService(VirtualNetworkService virtualNetworkService) {
        this.virtualNetService = virtualNetworkService;
    }

    protected void unbindVirtualNetService(VirtualNetworkService virtualNetworkService) {
        if (this.virtualNetService == virtualNetworkService) {
            this.virtualNetService = null;
        }
    }

    protected void bindOfAgentStore(OFAgentStore oFAgentStore) {
        this.ofAgentStore = oFAgentStore;
    }

    protected void unbindOfAgentStore(OFAgentStore oFAgentStore) {
        if (this.ofAgentStore == oFAgentStore) {
            this.ofAgentStore = null;
        }
    }

    private class InternalOFAgentStoreDelegate
    implements OFAgentStoreDelegate {
        private InternalOFAgentStoreDelegate() {
        }

        public void notify(OFAgentEvent event) {
            if (event != null) {
                OFAgentManager.this.log.trace("send ofagent event {}", (Object)event);
                OFAgentManager.this.process((Event)event);
            }
        }
    }

    private class InternalVirtualNetworkListener
    implements VirtualNetworkListener {
        private InternalVirtualNetworkListener() {
        }

        public boolean isRelevant(VirtualNetworkEvent event) {
            return Objects.equals(OFAgentManager.this.localId, OFAgentManager.this.leadershipService.getLeader(OFAgentManager.this.appId.name()));
        }

        public void event(VirtualNetworkEvent event) {
            switch ((VirtualNetworkEvent.Type)event.type()) {
                case NETWORK_UPDATED: {
                    break;
                }
                case NETWORK_REMOVED: {
                    break;
                }
            }
        }
    }

    private class InternalLeadershipListener
    implements LeadershipEventListener {
        private InternalLeadershipListener() {
        }

        public boolean isRelevant(LeadershipEvent event) {
            return false;
        }

        public void event(LeadershipEvent event) {
            switch ((LeadershipEvent.Type)event.type()) {
                default: 
            }
        }
    }
}

