/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ofagent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.ofagent.api.OFAgent;
import org.onosproject.ofagent.api.OFAgentEvent;
import org.onosproject.ofagent.api.OFAgentStore;
import org.onosproject.ofagent.api.OFAgentStoreDelegate;
import org.onosproject.ofagent.api.OFController;
import org.onosproject.ofagent.impl.DefaultOFAgent;
import org.onosproject.ofagent.impl.DefaultOFController;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class DistributedOFAgentStore
extends AbstractStore<OFAgentEvent, OFAgentStoreDelegate>
implements OFAgentStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ERR_NOT_FOUND = " does not exist";
    private static final String ERR_DUPLICATE = " already exists";
    private static final KryoNamespace SERIALIZER_OFAGENT = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{OFAgent.class}).register(new Class[]{OFAgent.State.class}).register(new Class[]{NetworkId.class}).register(new Class[]{DefaultOFAgent.class}).register(new Class[]{OFController.class}).register(new Class[]{DefaultOFController.class}).build();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private final ExecutorService eventExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)this.getClass().getSimpleName(), (String)"event-handler", (Logger)this.log));
    private final MapEventListener<NetworkId, OFAgent> ofAgentMapListener = new OFAgentMapListener();
    private ConsistentMap<NetworkId, OFAgent> ofAgentStore;

    @Activate
    protected void activate() {
        ApplicationId appId = this.coreService.registerApplication("org.onosproject.ofagent");
        this.ofAgentStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)SERIALIZER_OFAGENT))).withName("ofagentstore")).withApplicationId(appId)).build();
        this.ofAgentStore.addListener(this.ofAgentMapListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.ofAgentStore.removeListener(this.ofAgentMapListener);
        this.eventExecutor.shutdown();
        this.log.info("Stopped");
    }

    @Override
    public void createOfAgent(OFAgent ofAgent) {
        this.ofAgentStore.compute((Object)ofAgent.networkId(), (id, existing) -> {
            String error = ofAgent.networkId() + ERR_DUPLICATE;
            Preconditions.checkArgument((existing == null ? 1 : 0) != 0, (Object)error);
            return ofAgent;
        });
    }

    @Override
    public void updateOfAgent(OFAgent ofAgent) {
        this.ofAgentStore.compute((Object)ofAgent.networkId(), (id, existing) -> {
            String error = ofAgent.networkId() + ERR_NOT_FOUND;
            Preconditions.checkArgument((existing != null ? 1 : 0) != 0, (Object)error);
            return ofAgent;
        });
    }

    @Override
    public OFAgent removeOfAgent(NetworkId networkId) {
        Versioned ofAgent = this.ofAgentStore.remove((Object)networkId);
        return ofAgent == null ? null : (OFAgent)ofAgent.value();
    }

    @Override
    public OFAgent ofAgent(NetworkId networkId) {
        Versioned ofAgent = this.ofAgentStore.get((Object)networkId);
        return ofAgent == null ? null : (OFAgent)ofAgent.value();
    }

    @Override
    public Set<OFAgent> ofAgents() {
        Set ofAgents = this.ofAgentStore.values().stream().map(Versioned::value).collect(Collectors.toSet());
        return ImmutableSet.copyOf(ofAgents);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class OFAgentMapListener
    implements MapEventListener<NetworkId, OFAgent> {
        private OFAgentMapListener() {
        }

        public void event(MapEvent<NetworkId, OFAgent> event) {
            switch (event.type()) {
                case INSERT: {
                    DistributedOFAgentStore.this.eventExecutor.execute(() -> {
                        DistributedOFAgentStore.this.log.debug("OFAgent for network {} created", event.key());
                        DistributedOFAgentStore.this.notifyDelegate((Event)new OFAgentEvent(OFAgentEvent.Type.OFAGENT_CREATED, (OFAgent)event.newValue().value()));
                    });
                    break;
                }
                case UPDATE: {
                    DistributedOFAgentStore.this.eventExecutor.execute(() -> {
                        DistributedOFAgentStore.this.log.debug("OFAgent for network {} updated", event.key());
                        this.processUpdated((OFAgent)event.oldValue().value(), (OFAgent)event.newValue().value());
                    });
                    break;
                }
                case REMOVE: {
                    DistributedOFAgentStore.this.eventExecutor.execute(() -> {
                        DistributedOFAgentStore.this.log.debug("OFAgent for network {} removed", event.key());
                        DistributedOFAgentStore.this.notifyDelegate((Event)new OFAgentEvent(OFAgentEvent.Type.OFAGENT_REMOVED, (OFAgent)event.oldValue().value()));
                    });
                    break;
                }
            }
        }

        private void processUpdated(OFAgent oldValue, OFAgent newValue) {
            if (!oldValue.controllers().equals(newValue.controllers())) {
                oldValue.controllers().stream().filter(controller -> !newValue.controllers().contains(controller)).forEach(controller -> DistributedOFAgentStore.this.notifyDelegate((Event)new OFAgentEvent(OFAgentEvent.Type.OFAGENT_CONTROLLER_REMOVED, newValue, (OFController)controller)));
                newValue.controllers().stream().filter(controller -> !oldValue.controllers().contains(controller)).forEach(controller -> DistributedOFAgentStore.this.notifyDelegate((Event)new OFAgentEvent(OFAgentEvent.Type.OFAGENT_CONTROLLER_ADDED, newValue, (OFController)controller)));
            }
            if (oldValue.state() != newValue.state()) {
                OFAgentEvent.Type eventType = newValue.state() == OFAgent.State.STARTED ? OFAgentEvent.Type.OFAGENT_STARTED : OFAgentEvent.Type.OFAGENT_STOPPED;
                DistributedOFAgentStore.this.notifyDelegate((Event)new OFAgentEvent(eventType, newValue));
            }
        }
    }
}

