/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ofagent.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.onosproject.ofagent.api.OFSwitchCapabilities;
import org.projectfloodlight.openflow.protocol.OFCapabilities;

public final class DefaultOFSwitchCapabilities
implements OFSwitchCapabilities {
    private final Set<OFCapabilities> ofCapabilities;

    private DefaultOFSwitchCapabilities(Set<OFCapabilities> ofSwitchCapabilities) {
        this.ofCapabilities = ImmutableSet.copyOf(ofSwitchCapabilities);
    }

    @Override
    public Set<OFCapabilities> ofSwitchCapabilities() {
        return this.ofCapabilities;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements OFSwitchCapabilities.Builder {
        private Set<OFCapabilities> ofCapabilities = Sets.newHashSet();

        private Builder() {
        }

        @Override
        public Builder flowStats() {
            this.ofCapabilities.add(OFCapabilities.FLOW_STATS);
            return this;
        }

        @Override
        public Builder tableStats() {
            this.ofCapabilities.add(OFCapabilities.TABLE_STATS);
            return this;
        }

        @Override
        public Builder portStats() {
            this.ofCapabilities.add(OFCapabilities.PORT_STATS);
            return this;
        }

        @Override
        public Builder groupStats() {
            this.ofCapabilities.add(OFCapabilities.GROUP_STATS);
            return this;
        }

        @Override
        public Builder ipReasm() {
            this.ofCapabilities.add(OFCapabilities.IP_REASM);
            return this;
        }

        @Override
        public Builder queueStats() {
            this.ofCapabilities.add(OFCapabilities.QUEUE_STATS);
            return this;
        }

        @Override
        public Builder portBlocked() {
            this.ofCapabilities.add(OFCapabilities.PORT_BLOCKED);
            return this;
        }

        @Override
        public OFSwitchCapabilities build() {
            return new DefaultOFSwitchCapabilities(this.ofCapabilities);
        }
    }
}

