/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ofagent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.onosproject.net.Port;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.ofagent.api.OFSwitch;
import org.onosproject.ofagent.api.OFSwitchCapabilities;
import org.projectfloodlight.openflow.protocol.OFControllerRole;
import org.projectfloodlight.openflow.protocol.OFEchoReply;
import org.projectfloodlight.openflow.protocol.OFEchoRequest;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFeaturesReply;
import org.projectfloodlight.openflow.protocol.OFHello;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.DatapathId;

public final class DefaultOFSwitch
implements OFSwitch {
    private static final String ERR_CH_DUPLICATE = "Channel already exists: ";
    private static final String ERR_CH_NOT_FOUND = "Channel not found: ";
    private static final long NUM_BUFFERS = 1024L;
    private static final short NUM_TABLES = 3;
    private final DatapathId dpId;
    private final OFSwitchCapabilities capabilities;
    private final ConcurrentHashMap<Channel, OFControllerRole> controllerRoleMap = new ConcurrentHashMap();
    private static final OFFactory FACTORY = OFFactories.getFactory((OFVersion)OFVersion.OF_13);
    private int handshakeTransactionIds = -1;

    private DefaultOFSwitch(DatapathId dpid, OFSwitchCapabilities capabilities) {
        this.dpId = dpid;
        this.capabilities = capabilities;
    }

    public static DefaultOFSwitch of(DatapathId dpid, OFSwitchCapabilities capabilities) {
        Preconditions.checkNotNull((Object)dpid, (Object)"DPID cannot be null");
        Preconditions.checkNotNull((Object)capabilities, (Object)"OF capabilities cannot be null");
        return new DefaultOFSwitch(dpid, capabilities);
    }

    @Override
    public DatapathId dpid() {
        return this.dpId;
    }

    @Override
    public OFSwitchCapabilities capabilities() {
        return this.capabilities;
    }

    @Override
    public void addControllerChannel(Channel channel) {
        this.controllerRoleMap.compute(channel, (ch, existing) -> {
            String error = ERR_CH_DUPLICATE + channel.remoteAddress();
            Preconditions.checkArgument((existing == null ? 1 : 0) != 0, (Object)error);
            return OFControllerRole.ROLE_EQUAL;
        });
    }

    @Override
    public void deleteControllerChannel(Channel channel) {
        if (this.controllerRoleMap.remove(channel) == null) {
            String error = ERR_CH_NOT_FOUND + channel.remoteAddress();
            throw new IllegalStateException(error);
        }
    }

    @Override
    public void setRole(Channel channel, OFControllerRole role) {
        this.controllerRoleMap.compute(channel, (ch, existing) -> {
            String error = ERR_CH_NOT_FOUND + channel.remoteAddress();
            Preconditions.checkNotNull((Object)existing, (Object)error);
            return role;
        });
    }

    @Override
    public OFControllerRole role(Channel channel) {
        OFControllerRole role = this.controllerRoleMap.get(channel);
        if (role == null) {
            String error = ERR_CH_NOT_FOUND + channel.remoteAddress();
            throw new IllegalStateException(error);
        }
        return role;
    }

    @Override
    public Set<Channel> controllerChannels() {
        return ImmutableSet.copyOf((Collection)this.controllerRoleMap.keySet());
    }

    @Override
    public void processPortAdded(Port port) {
    }

    @Override
    public void processPortDown(Port port) {
    }

    @Override
    public void processPortUp(Port port) {
    }

    @Override
    public void processFlowRemoved(FlowRule flowRule) {
    }

    @Override
    public void processPacketIn(InboundPacket packet) {
    }

    @Override
    public void processControllerCommand(Channel channel, OFMessage msg) {
    }

    @Override
    public void processStatsRequest(Channel channel, OFMessage msg) {
    }

    @Override
    public void processRoleRequest(Channel channel, OFMessage msg) {
    }

    @Override
    public void processFeaturesRequest(Channel channel, OFMessage msg) {
        OFFeaturesReply ofFeaturesReply = FACTORY.buildFeaturesReply().setDatapathId(this.dpId).setNBuffers(1024L).setNTables((short)3).setCapabilities(this.capabilities.ofSwitchCapabilities()).setXid(msg.getXid()).build();
        channel.writeAndFlush(Collections.singletonList(ofFeaturesReply));
    }

    @Override
    public void processLldp(Channel channel, OFMessage msg) {
    }

    @Override
    public void sendOfHello(Channel channel) {
        OFHello ofHello = FACTORY.buildHello().setXid((long)this.handshakeTransactionIds--).build();
        channel.writeAndFlush(Collections.singletonList(ofHello));
    }

    @Override
    public void processEchoRequest(Channel channel, OFMessage msg) {
        OFEchoReply ofEchoReply = FACTORY.buildEchoReply().setXid(msg.getXid()).setData(((OFEchoRequest)msg).getData()).build();
        channel.writeAndFlush(Collections.singletonList(ofEchoReply));
    }
}

