/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ofagent.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.TpPort;
import org.onosproject.ofagent.api.OFController;

public final class DefaultOFController
implements OFController {
    private final IpAddress ip;
    private final TpPort port;

    private DefaultOFController(IpAddress ip, TpPort port) {
        this.ip = ip;
        this.port = port;
    }

    public static DefaultOFController of(IpAddress ip, TpPort port) {
        Preconditions.checkNotNull((Object)ip, (Object)"Controller IP address cannot be null");
        Preconditions.checkNotNull((Object)port, (Object)"Controller port address cannot be null");
        return new DefaultOFController(ip, port);
    }

    @Override
    public IpAddress ip() {
        return this.ip;
    }

    @Override
    public TpPort port() {
        return this.port;
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultOFController) {
            DefaultOFController that = (DefaultOFController)obj;
            if (Objects.equals(this.ip, that.ip) && Objects.equals(this.port, that.port)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ip", (Object)this.ip).add("port", (Object)this.port).toString();
    }
}

