/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ofagent.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.ofagent.api.OFAgent;
import org.onosproject.ofagent.api.OFController;

public final class DefaultOFAgent
implements OFAgent {
    private final NetworkId networkId;
    private final Set<OFController> controllers;
    private final OFAgent.State state;

    private DefaultOFAgent(NetworkId networkId, Set<OFController> controllers, OFAgent.State state) {
        this.networkId = networkId;
        this.controllers = controllers;
        this.state = state;
    }

    @Override
    public NetworkId networkId() {
        return this.networkId;
    }

    @Override
    public Set<OFController> controllers() {
        return this.controllers;
    }

    @Override
    public OFAgent.State state() {
        return this.state;
    }

    public int hashCode() {
        return Objects.hash(this.networkId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultOFAgent) {
            DefaultOFAgent that = (DefaultOFAgent)obj;
            if (Objects.equals(this.networkId, that.networkId)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("networkId", (Object)this.networkId).add("controllers", this.controllers).add("state", (Object)this.state).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements OFAgent.Builder {
        private NetworkId networkId;
        private Set<OFController> controllers = Sets.newHashSet();
        private OFAgent.State state;

        private Builder() {
        }

        @Override
        public OFAgent build() {
            Preconditions.checkNotNull((Object)this.networkId, (Object)"Network ID cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.state), (Object)"State cannot be null");
            this.controllers = this.controllers == null ? ImmutableSet.of() : this.controllers;
            return new DefaultOFAgent(this.networkId, this.controllers, this.state);
        }

        @Override
        public Builder from(OFAgent ofAgent) {
            this.networkId = ofAgent.networkId();
            this.controllers = Sets.newHashSet(ofAgent.controllers());
            this.state = ofAgent.state();
            return this;
        }

        @Override
        public Builder networkId(NetworkId networkId) {
            this.networkId = networkId;
            return this;
        }

        @Override
        public Builder controllers(Set<OFController> controllers) {
            this.controllers = controllers;
            return this;
        }

        @Override
        public OFAgent.Builder addController(OFController controller) {
            this.controllers.add(controller);
            return this;
        }

        @Override
        public OFAgent.Builder deleteController(OFController controller) {
            this.controllers.remove(controller);
            return this;
        }

        @Override
        public Builder state(OFAgent.State state) {
            this.state = state;
            return this;
        }
    }
}

