/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ofagent.cli;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.ofagent.api.OFSwitch;
import org.onosproject.ofagent.api.OFSwitchService;

@Command(scope="onos", name="ofagent-switches", description="Lists all OF switches")
public class OFSwitchListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "%-35s%-8s";
    @Argument(index=0, name="network", description="Virtual network ID", required=false, multiValued=false)
    private long networkId = (Long)NetworkId.NONE.id();

    protected void execute() {
        OFSwitchService service = (OFSwitchService)OFSwitchListCommand.get(OFSwitchService.class);
        Set<OFSwitch> ofSwitches = this.networkId != (Long)NetworkId.NONE.id() ? service.ofSwitches(NetworkId.networkId((long)this.networkId)) : service.ofSwitches();
        this.print(FORMAT, new Object[]{"DPID", "Connected controllers"});
        ofSwitches.forEach(ofSwitch -> {
            Set channels = ofSwitch.controllerChannels().stream().map(channel -> channel.remoteAddress().toString()).collect(Collectors.toSet());
            this.print(FORMAT, new Object[]{ofSwitch.dpid(), channels});
        });
    }
}

