/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ofagent.cli;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.ofagent.api.OFAgentService;

@Command(scope="onos", name="ofagents", description="Lists all ofagents")
public class OFAgentListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "%-10s%-10s%-8s";
    private static final String CTRL = "%s:%s";

    protected void execute() {
        OFAgentService service = (OFAgentService)OFAgentListCommand.get(OFAgentService.class);
        this.print(FORMAT, new Object[]{"Network", "Status", "Controllers"});
        service.agents().forEach(agent -> {
            Set ctrls = agent.controllers().stream().map(ctrl -> String.format(CTRL, ctrl.ip(), ctrl.port())).collect(Collectors.toSet());
            this.print(FORMAT, new Object[]{agent.networkId(), agent.state().name(), ctrls});
        });
    }
}

