/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ofagent.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.IpAddress;
import org.onlab.packet.TpPort;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.ofagent.api.OFAgent;
import org.onosproject.ofagent.api.OFAgentAdminService;
import org.onosproject.ofagent.api.OFAgentService;
import org.onosproject.ofagent.impl.DefaultOFAgent;
import org.onosproject.ofagent.impl.DefaultOFController;

@Command(scope="onos", name="ofagent-controller-delete", description="Deletes a controller from the ofagent")
public class OFAgentDeleteControllerCommand
extends AbstractShellCommand {
    private static final String PATTERN_IP_PORT = "\\d{1,3}(?:\\.\\d{1,3}){3}(?::\\d{1,5})";
    @Argument(index=0, name="network", description="Virtual network ID", required=true, multiValued=false)
    private long networkId = (Long)NetworkId.NONE.id();
    @Argument(index=1, name="controller", description="External controller with IP:PORT format", required=true, multiValued=false)
    private String strCtrl;

    protected void execute() {
        if (!this.isValidController(this.strCtrl)) {
            this.error("Invalid controller string %s, must be IP:PORT", new Object[]{this.strCtrl});
            return;
        }
        OFAgentService service = (OFAgentService)OFAgentDeleteControllerCommand.get(OFAgentService.class);
        OFAgentAdminService adminService = (OFAgentAdminService)OFAgentDeleteControllerCommand.get(OFAgentAdminService.class);
        OFAgent existing = service.agent(NetworkId.networkId((long)this.networkId));
        if (existing == null) {
            this.error("OFAgent for network %s does not exist", new Object[]{this.networkId});
            return;
        }
        String[] temp = this.strCtrl.split(":");
        OFAgent updated = DefaultOFAgent.builder().from(existing).deleteController(DefaultOFController.of(IpAddress.valueOf((String)temp[0]), TpPort.tpPort((int)Integer.valueOf(temp[1])))).build();
        adminService.updateAgent(updated);
    }

    private boolean isValidController(String ctrl) {
        if (!ctrl.matches(PATTERN_IP_PORT)) {
            return false;
        }
        String[] temp = ctrl.split(":");
        try {
            IpAddress.valueOf((String)temp[0]);
            TpPort.tpPort((int)Integer.valueOf(temp[1]));
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

