/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ofagent.cli;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.IpAddress;
import org.onlab.packet.TpPort;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.ofagent.api.OFAgent;
import org.onosproject.ofagent.api.OFAgentAdminService;
import org.onosproject.ofagent.impl.DefaultOFAgent;
import org.onosproject.ofagent.impl.DefaultOFController;

@Command(scope="onos", name="ofagent-create", description="Add a new ofagent")
public class OFAgentCreateCommand
extends AbstractShellCommand {
    private static final String PATTERN_IP_PORT = "\\d{1,3}(?:\\.\\d{1,3}){3}(?::\\d{1,5})";
    @Argument(index=0, name="network", description="Virtual network ID", required=true, multiValued=false)
    private long networkId = (Long)NetworkId.NONE.id();
    @Argument(index=1, name="controllers", description="List of external controllers with IP:PORT format", required=false, multiValued=true)
    private String[] strCtrls = new String[0];

    protected void execute() {
        HashSet ctrls = Sets.newHashSet();
        for (String strCtrl : this.strCtrls) {
            if (!this.isValidController(strCtrl)) {
                this.print("Invalid controller %s, ignores it.", new Object[]{strCtrl});
                continue;
            }
            String[] temp = strCtrl.split(":");
            ctrls.add(DefaultOFController.of(IpAddress.valueOf((String)temp[0]), TpPort.tpPort((int)Integer.valueOf(temp[1]))));
        }
        OFAgentAdminService adminService = (OFAgentAdminService)OFAgentCreateCommand.get(OFAgentAdminService.class);
        OFAgent ofAgent = ((DefaultOFAgent.Builder)DefaultOFAgent.builder().networkId(NetworkId.networkId((long)this.networkId)).controllers((Set)ctrls)).state(OFAgent.State.STOPPED).build();
        adminService.createAgent(ofAgent);
        this.print("Successfully created OFAgent for network %s", new Object[]{this.networkId});
    }

    private boolean isValidController(String ctrl) {
        if (!ctrl.matches(PATTERN_IP_PORT)) {
            return false;
        }
        String[] temp = ctrl.split(":");
        try {
            IpAddress.valueOf((String)temp[0]);
            TpPort.tpPort((int)Integer.valueOf(temp[1]));
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

