/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.loadtest;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.StorageService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={DistributedConsensusLoadTest.class})
public class DistributedConsensusLoadTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ApplicationId appId;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private static final int DEFAULT_RATE = 100;
    private static final int TOTAL_COUNTERS = 50;
    @Property(name="rate", intValue={100}, label="Total number of increments per second to the atomic counter")
    protected int rate = 0;
    private final AtomicLong previousReportTime = new AtomicLong(0L);
    private final AtomicLong previousCount = new AtomicLong(0L);
    private final AtomicInteger increments = new AtomicInteger(0);
    private final List<AsyncAtomicCounter> counters = Lists.newArrayList();
    private final ScheduledExecutorService runner = Executors.newSingleThreadScheduledExecutor();
    private final ScheduledExecutorService reporter = Executors.newSingleThreadScheduledExecutor();

    @Activate
    public void activate(ComponentContext context) {
        this.configService.registerProperties(this.getClass());
        this.appId = this.coreService.registerApplication("org.onosproject.loadtest");
        this.log.info("Started with {}", (Object)this.appId);
        for (int i = 0; i < 50; ++i) {
            AsyncAtomicCounter counter = this.storageService.getAsyncAtomicCounter(String.format("onos-app-loadtest-counter-%d", i));
            this.counters.add(counter);
        }
        this.reporter.scheduleWithFixedDelay(() -> Tools.allOf(this.counters.stream().map(AsyncAtomicCounter::get).collect(Collectors.toList())).whenComplete((r, e) -> {
            if (e == null) {
                long newCount = (Long)r.stream().reduce(Long::sum).get();
                long currentTime = System.currentTimeMillis();
                long delta = currentTime - this.previousReportTime.getAndSet(currentTime);
                long rate = (newCount - this.previousCount.getAndSet(newCount)) * 1000L / delta;
                this.log.info("{} updates per second", (Object)rate);
            } else {
                this.log.warn(e.getMessage());
            }
        }), 5L, 5L, TimeUnit.SECONDS);
        this.modified(null);
    }

    private void startTest() {
        this.stopped.set(false);
        RateLimiter limiter = RateLimiter.create((double)this.rate);
        Semaphore s = new Semaphore(100);
        while (!this.stopped.get()) {
            limiter.acquire();
            s.acquireUninterruptibly();
            this.counters.get(RandomUtils.nextInt((int)50)).incrementAndGet().whenComplete((r, e) -> {
                s.release();
                if (e == null) {
                    this.increments.incrementAndGet();
                }
            });
        }
    }

    private void stopTest() {
        this.stopped.set(true);
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.configService.unregisterProperties(this.getClass(), false);
        this.stopTest();
        this.runner.shutdown();
        this.reporter.shutdown();
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        int newRate = 100;
        if (context != null) {
            Dictionary properties = context.getProperties();
            try {
                String s = Tools.get((Dictionary)properties, (String)"rate");
                newRate = Strings.isNullOrEmpty((String)s) ? this.rate : Integer.parseInt(s.trim());
            }
            catch (Exception e) {
                return;
            }
        }
        if (newRate != this.rate) {
            this.log.info("Per node rate changed to {}", (Object)newRate);
            this.rate = newRate;
            this.stopTest();
            this.runner.execute(this::startTest);
        }
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }
}

