/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cordsupport;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.onosproject.net.Device;
import org.onosproject.net.Host;
import org.onosproject.net.Link;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.LinkService;
import org.onosproject.rest.AbstractWebResource;

@Path(value="topo")
public class CordSupportWebResource
extends AbstractWebResource {
    private static final String TILDE = "~";
    private final ObjectMapper mapper = new ObjectMapper();
    private final Set<String> seenLinks = new HashSet();

    @GET
    public Response queryTopology() {
        ObjectNode root = this.mapper.createObjectNode();
        this.addDevices(root);
        this.addHosts(root);
        this.addLinks(root);
        return Response.ok((Object)root.toString(), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private void addDevices(ObjectNode root) {
        ArrayNode devices = this.createArray(root, "devices");
        ((DeviceService)this.get(DeviceService.class)).getDevices().forEach(dev -> devices.add((JsonNode)this.json(dev)));
    }

    private void addHosts(ObjectNode root) {
        ArrayNode hosts = this.createArray(root, "hosts");
        ((HostService)this.get(HostService.class)).getHosts().forEach(host -> hosts.add((JsonNode)this.json(host)));
    }

    private void addLinks(ObjectNode root) {
        ArrayNode links = this.createArray(root, "links");
        this.seenLinks.clear();
        ((LinkService)this.get(LinkService.class)).getLinks().forEach(link -> {
            String canon = this.canonicalRep(link);
            if (!this.seenLinks.contains(canon)) {
                this.seenLinks.add(canon);
                links.add((JsonNode)this.json(link));
            }
        });
    }

    private String canonicalRep(Link link) {
        String b;
        String a = link.src().toString();
        return a.compareTo(b = link.dst().toString()) < 0 ? a + TILDE + b : b + TILDE + a;
    }

    private ArrayNode createArray(ObjectNode root, String key) {
        ArrayNode result = this.mapper.createArrayNode();
        root.set(key, (JsonNode)result);
        return result;
    }

    private ObjectNode json(Device device) {
        return this.mapper.createObjectNode().put("id", device.id().toString()).put("type", device.type().toString());
    }

    private ObjectNode json(Host host) {
        return this.mapper.createObjectNode().put("id", host.id().toString()).put("location", host.location().toString());
    }

    private ObjectNode json(Link link) {
        return this.mapper.createObjectNode().put("canon", this.canonicalRep(link)).put("src", link.src().toString()).put("dst", link.dst().toString());
    }
}

