/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.oplink;

import java.util.List;
import java.util.Set;
import org.onlab.util.Frequency;
import org.onosproject.core.CoreService;
import org.onosproject.driver.extensions.OplinkAttenuation;
import org.onosproject.drivers.oplink.OplinkCrossConnect;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.GridType;
import org.onosproject.net.Lambda;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.PortNumber;
import org.onosproject.net.driver.HandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.OchSignalCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.instructions.Instructions;

public final class OplinkOpticalUtility {
    public static final GridType GRID_TYPE = GridType.DWDM;
    public static final int SLOT_GRANULARITY = 4;
    public static final ChannelSpacing CHANNEL_SPACING = ChannelSpacing.CHL_50GHZ;
    public static final Frequency START_CENTER_FREQ = Frequency.ofGHz((long)191350L);
    public static final Frequency STOP_CENTER_FREQ = Frequency.ofGHz((long)196100L);
    public static final int POWER_MULTIPLIER = 100;
    public static final long MIN_ATTENUATION = 0L;
    public static final long MAX_ATTENUATION = 2500L;
    private static final int DEFAULT_ATT = 0;
    private static final int DEFAULT_PRIORITY = 88;
    private static final String DEFAULT_APP = "org.onosproject.drivers.oplink";

    private OplinkOpticalUtility() {
    }

    public static OplinkCrossConnect fromFlowRule(HandlerBehaviour behaviour, FlowRule rule) {
        Set criterions = rule.selector().criteria();
        int channel = criterions.stream().filter(c -> c instanceof OchSignalCriterion).map(c -> ((OchSignalCriterion)c).lambda().spacingMultiplier()).findAny().orElse(null);
        PortNumber inPort = criterions.stream().filter(c -> c instanceof PortCriterion).map(c -> ((PortCriterion)c).port()).findAny().orElse(null);
        List instructions = rule.treatment().immediate();
        PortNumber outPort = instructions.stream().filter(c -> c instanceof Instructions.OutputInstruction).map(c -> ((Instructions.OutputInstruction)c).port()).findAny().orElse(null);
        int attenuation = instructions.stream().filter(c -> c instanceof Instructions.ExtensionInstructionWrapper).map(c -> ((Instructions.ExtensionInstructionWrapper)c).extensionInstruction()).filter(c -> c instanceof OplinkAttenuation).map(c -> ((OplinkAttenuation)c).getAttenuation()).findAny().orElse(0);
        return new OplinkCrossConnect(inPort, outPort, channel, attenuation);
    }

    public static FlowRule toFlowRule(HandlerBehaviour behaviour, OplinkCrossConnect cfg) {
        return OplinkOpticalUtility.toFlowRule(behaviour, cfg.getInPort(), cfg.getOutPort(), cfg.getChannel());
    }

    public static FlowRule toFlowRule(HandlerBehaviour behaviour, PortNumber inPort, PortNumber outPort, Integer channel) {
        FlowRuleService service = (FlowRuleService)behaviour.handler().get(FlowRuleService.class);
        Iterable entries = service.getFlowEntries(behaviour.data().deviceId());
        for (FlowEntry entry : entries) {
            Set criterions = entry.selector().criteria();
            PortNumber ip = criterions.stream().filter(c -> c instanceof PortCriterion).map(c -> ((PortCriterion)c).port()).findAny().orElse(null);
            Integer ch = criterions.stream().filter(c -> c instanceof OchSignalCriterion).map(c -> ((OchSignalCriterion)c).lambda().spacingMultiplier()).findAny().orElse(null);
            PortNumber op = entry.treatment().immediate().stream().filter(c -> c instanceof Instructions.OutputInstruction).map(c -> ((Instructions.OutputInstruction)c).port()).findAny().orElse(null);
            if (!inPort.equals((Object)ip) || !channel.equals(ch) || !outPort.equals((Object)op)) continue;
            return entry;
        }
        TrafficSelector selector = DefaultTrafficSelector.builder().matchInPort(inPort).add(Criteria.matchOchSignalType((OchSignalType)OchSignalType.FIXED_GRID)).add(Criteria.matchLambda((Lambda)Lambda.ochSignal((GridType)GRID_TYPE, (ChannelSpacing)CHANNEL_SPACING, (int)channel, (int)4))).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(outPort).build();
        return DefaultFlowRule.builder().forDevice(behaviour.data().deviceId()).withSelector(selector).withTreatment(treatment).withPriority(88).fromApp(((CoreService)behaviour.handler().get(CoreService.class)).getAppId(DEFAULT_APP)).build();
    }
}

