/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.oplink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.onosproject.drivers.oplink.OplinkNetconfUtility;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointDescription;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointState;
import org.onosproject.net.behaviour.protection.ProtectionConfigBehaviour;
import org.onosproject.net.behaviour.protection.TransportEndpointDescription;
import org.onosproject.net.behaviour.protection.TransportEndpointId;
import org.onosproject.net.behaviour.protection.TransportEndpointState;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BasicLinkConfig;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.link.LinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplinkOpticalProtectionSwitchConfig
extends AbstractHandlerBehaviour
implements ProtectionConfigBehaviour {
    private static final String KEY_CONFIG = "config";
    private static final String KEY_OPSCONFIG = "ops-config";
    private static final String KEY_STATE = "state";
    private static final String KEY_OPSSTATE = "ops-state";
    private static final String KEY_NAME_PRIMARY = "primary";
    private static final String KEY_NAME_SECONDARY = "secondary";
    private static final String KEY_OPT_FORCE = "force";
    private static final String KEY_OPT_MANUAL = "manual";
    private static final String KEY_OPT_AUTO = "auto-revertive";
    private static final String FMT_OPT = "%s-%s";
    private static final PortNumber PORT_VIRTUAL = PortNumber.portNumber((long)0L);
    private static final PortNumber PORT_PRIMARY = PortNumber.portNumber((long)3L, (String)"primary_port");
    private static final PortNumber PORT_SECONDARY = PortNumber.portNumber((long)5L, (String)"secondary_port");
    private static final Logger log = LoggerFactory.getLogger(OplinkOpticalProtectionSwitchConfig.class);

    public CompletableFuture<ConnectPoint> createProtectionEndpoint(ProtectedTransportEndpointDescription configuration) {
        this.addLink(this.getPeerId());
        return CompletableFuture.completedFuture(new ConnectPoint((ElementId)this.data().deviceId(), PORT_VIRTUAL));
    }

    public CompletableFuture<ConnectPoint> updateProtectionEndpoint(ConnectPoint identifier, ProtectedTransportEndpointDescription configuration) {
        return CompletableFuture.completedFuture(identifier);
    }

    public CompletableFuture<Boolean> deleteProtectionEndpoint(ConnectPoint identifier) {
        if (identifier.port().equals((Object)PORT_VIRTUAL)) {
            this.removeLink(this.getPeerId());
            return CompletableFuture.completedFuture(true);
        }
        return CompletableFuture.completedFuture(false);
    }

    public CompletableFuture<Map<ConnectPoint, ProtectedTransportEndpointDescription>> getProtectionEndpointConfigs() {
        HashMap<ConnectPoint, ProtectedTransportEndpointDescription> map = new HashMap<ConnectPoint, ProtectedTransportEndpointDescription>();
        map.put(new ConnectPoint((ElementId)this.data().deviceId(), PORT_VIRTUAL), this.buildProtectedTransportEndpointDescription());
        return CompletableFuture.completedFuture(map);
    }

    public CompletableFuture<Map<ConnectPoint, ProtectedTransportEndpointState>> getProtectionEndpointStates() {
        HashMap<ConnectPoint, ProtectedTransportEndpointState> map = new HashMap<ConnectPoint, ProtectedTransportEndpointState>();
        map.put(new ConnectPoint((ElementId)this.data().deviceId(), PORT_VIRTUAL), this.buildProtectedTransportEndpointState());
        return CompletableFuture.completedFuture(map);
    }

    public CompletableFuture<Void> switchWorkingPath(ConnectPoint identifier, int index) {
        return this.switchToManual(identifier, index);
    }

    public CompletableFuture<Void> switchToForce(ConnectPoint identifier, int index) {
        return ((CompletableFuture)((CompletableFuture)this.getProtectionEndpointConfig(identifier).thenApply(m -> (TransportEndpointDescription)m.paths().get(index))).thenApply(m -> this.switchDevice(this.formatOperation(m.output().connectPoint().port(), KEY_OPT_FORCE)))).thenApply(m -> null);
    }

    public CompletableFuture<Void> switchToManual(ConnectPoint identifier, int index) {
        return ((CompletableFuture)((CompletableFuture)this.getProtectionEndpointConfig(identifier).thenApply(m -> (TransportEndpointDescription)m.paths().get(index))).thenApply(m -> this.switchDevice(this.formatOperation(m.output().connectPoint().port(), KEY_OPT_MANUAL)))).thenApply(m -> null);
    }

    public CompletableFuture<Void> switchToAutomatic(ConnectPoint identifier) {
        this.switchDevice(KEY_OPT_AUTO);
        return CompletableFuture.completedFuture(null);
    }

    private ProtectedTransportEndpointState buildProtectedTransportEndpointState() {
        PortNumber activePort = this.acquireActivePort();
        ArrayList<TransportEndpointState> states = new ArrayList<TransportEndpointState>();
        states.add(this.buildTransportEndpointState(this.data().deviceId(), PORT_PRIMARY, activePort));
        states.add(this.buildTransportEndpointState(this.data().deviceId(), PORT_SECONDARY, activePort));
        return ProtectedTransportEndpointState.builder().withPathStates(states).withDescription(this.buildProtectedTransportEndpointDescription()).withActivePathIndex(this.getActiveIndex(states, activePort)).build();
    }

    private ProtectedTransportEndpointDescription buildProtectedTransportEndpointDescription() {
        ArrayList<TransportEndpointDescription> descs = new ArrayList<TransportEndpointDescription>();
        descs.add(this.buildTransportEndpointDescription(this.data().deviceId(), PORT_PRIMARY));
        descs.add(this.buildTransportEndpointDescription(this.data().deviceId(), PORT_SECONDARY));
        return ProtectedTransportEndpointDescription.of(descs, (DeviceId)this.getPeerId(), (String)"protection:fingerprint");
    }

    private TransportEndpointDescription buildTransportEndpointDescription(DeviceId id, PortNumber port) {
        return TransportEndpointDescription.builder().withOutput(new FilteredConnectPoint(new ConnectPoint((ElementId)id, port))).build();
    }

    private TransportEndpointState buildTransportEndpointState(DeviceId id, PortNumber port, PortNumber activePort) {
        String status = port.equals((Object)activePort) ? "inService" : "outOfService";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("inputStatus", status);
        return TransportEndpointState.builder().withId(TransportEndpointId.of((String)port.name())).withDescription(this.buildTransportEndpointDescription(id, port)).addAttributes(attributes).build();
    }

    private int getActiveIndex(List<TransportEndpointState> pathStates, PortNumber activePort) {
        int activeIndex = 0;
        for (TransportEndpointState state : pathStates) {
            if (activePort.equals((Object)state.description().output().connectPoint().port())) {
                return activeIndex;
            }
            ++activeIndex;
        }
        return -1;
    }

    private PortNumber acquireActivePort() {
        String filter = OplinkNetconfUtility.xmlOpen(OplinkNetconfUtility.KEY_OPENOPTICALDEV_XMLNS) + OplinkNetconfUtility.xmlOpen(KEY_STATE) + OplinkNetconfUtility.xmlEmpty(KEY_OPSSTATE) + OplinkNetconfUtility.xmlClose(KEY_STATE) + OplinkNetconfUtility.xmlClose("open-optical-device");
        String reply = OplinkNetconfUtility.netconfGet(this.handler(), filter);
        log.debug("Service state replying, {}", (Object)reply);
        return reply.contains(KEY_NAME_PRIMARY) ? PORT_PRIMARY : PORT_SECONDARY;
    }

    private String formatOperation(PortNumber port, String operation) {
        String key = port.name().contains(KEY_NAME_PRIMARY) ? KEY_NAME_PRIMARY : KEY_NAME_SECONDARY;
        return String.format(FMT_OPT, operation, key);
    }

    private boolean switchDevice(String operation) {
        log.debug("Switch to {} for Device {}", (Object)operation, (Object)this.data().deviceId());
        String cfg = OplinkNetconfUtility.xmlOpen(OplinkNetconfUtility.KEY_OPENOPTICALDEV_XMLNS) + OplinkNetconfUtility.xmlOpen(KEY_CONFIG) + OplinkNetconfUtility.xml(KEY_OPSCONFIG, operation) + OplinkNetconfUtility.xmlClose(KEY_CONFIG) + OplinkNetconfUtility.xmlClose("open-optical-device");
        return OplinkNetconfUtility.netconfEditConfig(this.handler(), "merge", cfg);
    }

    private void addLink(DeviceId peerId) {
        if (peerId == null) {
            log.warn("PeerID is null for device {}", (Object)this.data().deviceId());
            return;
        }
        LinkKey link = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)peerId, PORT_VIRTUAL), (ConnectPoint)new ConnectPoint((ElementId)this.data().deviceId(), PORT_VIRTUAL));
        ((BasicLinkConfig)((NetworkConfigService)this.handler().get(NetworkConfigService.class)).addConfig((Object)link, BasicLinkConfig.class)).type(Link.Type.VIRTUAL).apply();
    }

    private void removeLink(DeviceId peerId) {
        if (peerId == null) {
            log.warn("PeerID is null for device {}", (Object)this.data().deviceId());
            return;
        }
        LinkKey link = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)peerId, PORT_VIRTUAL), (ConnectPoint)new ConnectPoint((ElementId)this.data().deviceId(), PORT_VIRTUAL));
        ((NetworkConfigService)this.handler().get(NetworkConfigService.class)).removeConfig((Object)link, BasicLinkConfig.class);
    }

    private DeviceId getPeerId() {
        ConnectPoint dstCp = new ConnectPoint((ElementId)this.data().deviceId(), PORT_VIRTUAL);
        Set links = ((LinkService)this.handler().get(LinkService.class)).getIngressLinks(dstCp);
        for (Link l : links) {
            if (l.type() != Link.Type.VIRTUAL) continue;
            return l.src().deviceId();
        }
        return this.data().deviceId();
    }
}

