/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.oplink;

import com.google.common.collect.Range;
import java.util.Optional;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.onosproject.driver.extensions.OplinkAttenuation;
import org.onosproject.drivers.oplink.OplinkCrossConnect;
import org.onosproject.drivers.oplink.OplinkNetconfUtility;
import org.onosproject.drivers.oplink.OplinkOpticalUtility;
import org.onosproject.net.Direction;
import org.onosproject.net.OchSignal;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.PowerConfig;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.HandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplinkOpticalPowerConfig<T>
extends AbstractHandlerBehaviour
implements PowerConfig<T> {
    public static final String KEY_CHNUM = "wavelength-number";
    public static final String KEY_CHPWR = "wavelength-power";
    public static final String KEY_CHSTATS = "wavelength-stats";
    public static final String KEY_OCMSTATS = "ocm-stats";
    public static final String KEY_PORTDIRECT_RX = "rx";
    public static final String KEY_PORTDIRECT_TX = "tx";
    public static final String KEY_PORTTARPWR = "port-target-power";
    public static final String KEY_PORTCURPWR = "port-current-power";
    public static final String KEY_PORTPROPERTY = "port-property";
    public static final String KEY_PORTPWRCAPMINRX = "port-power-capability-min-rx";
    public static final String KEY_PORTPWRCAPMAXRX = "port-power-capability-max-rx";
    public static final String KEY_PORTPWRCAPMINTX = "port-power-capability-min-tx";
    public static final String KEY_PORTPWRCAPMAXTX = "port-power-capability-max-tx";
    public static final String KEY_PORTS_PORT = String.format("%s.%s", OplinkNetconfUtility.KEY_DATA_PORTS, "port");
    public static final String KEY_PORTS_PORT_PROPERTY = String.format("%s.%s", KEY_PORTS_PORT, "port-property");
    private static final Logger log = LoggerFactory.getLogger(OplinkOpticalPowerConfig.class);

    public Optional<Long> getTargetPower(PortNumber port, T component) {
        return Optional.ofNullable(this.acquireTargetPower(port, component));
    }

    public void setTargetPower(PortNumber port, T component, long power) {
        if (component instanceof OchSignal) {
            this.setChannelTargetPower(port, (OchSignal)component, power);
        } else {
            this.setPortTargetPower(port, power);
        }
    }

    public Optional<Long> currentPower(PortNumber port, T component) {
        return Optional.ofNullable(this.acquireCurrentPower(port, component));
    }

    public Optional<Range<Long>> getTargetPowerRange(PortNumber port, T component) {
        return Optional.ofNullable(this.getTxPowerRange(port, component));
    }

    public Optional<Range<Long>> getInputPowerRange(PortNumber port, T component) {
        return Optional.ofNullable(this.getRxPowerRange(port, component));
    }

    private String getPortPowerFilter(PortNumber port, String selection) {
        return OplinkNetconfUtility.xmlOpen(OplinkNetconfUtility.KEY_OPENOPTICALDEV_XMLNS) + OplinkNetconfUtility.xmlOpen("ports") + OplinkNetconfUtility.xml("port-id", Long.toString(port.toLong())) + OplinkNetconfUtility.xmlOpen("port") + OplinkNetconfUtility.xmlEmpty(selection) + OplinkNetconfUtility.xmlClose("port") + OplinkNetconfUtility.xmlClose("ports") + OplinkNetconfUtility.xmlClose("open-optical-device");
    }

    private String getChannelPowerFilter(PortNumber port, OchSignal channel) {
        return OplinkNetconfUtility.xmlOpen(OplinkNetconfUtility.KEY_OPENOPTICALDEV_XMLNS) + OplinkNetconfUtility.xmlOpen("ports") + OplinkNetconfUtility.xml("port-id", Long.toString(port.toLong())) + OplinkNetconfUtility.xmlOpen("port") + OplinkNetconfUtility.xmlOpen(KEY_OCMSTATS) + OplinkNetconfUtility.xml(KEY_CHNUM, Integer.toString(channel.spacingMultiplier())) + OplinkNetconfUtility.xmlEmpty(KEY_CHSTATS) + OplinkNetconfUtility.xmlClose(KEY_OCMSTATS) + OplinkNetconfUtility.xmlClose("port") + OplinkNetconfUtility.xmlClose("ports") + OplinkNetconfUtility.xmlClose("open-optical-device");
    }

    private String getChannelAttenuationFilter(PortNumber port, OchSignal channel) {
        return OplinkNetconfUtility.xmlOpen(OplinkNetconfUtility.KEY_OPENOPTICALDEV_XMLNS) + OplinkNetconfUtility.xmlOpen("connections") + OplinkNetconfUtility.xml("connection-id", Integer.toString(channel.spacingMultiplier())) + OplinkNetconfUtility.xmlEmpty("attenuation") + OplinkNetconfUtility.xmlClose("connections") + OplinkNetconfUtility.xmlClose("open-optical-device");
    }

    private String getPowerRangeFilter(PortNumber port, String direction) {
        return OplinkNetconfUtility.xmlOpen(OplinkNetconfUtility.KEY_OPENOPTICALDEV_XMLNS) + OplinkNetconfUtility.xmlOpen("ports") + OplinkNetconfUtility.xml("port-id", Long.toString(port.toLong())) + OplinkNetconfUtility.xmlOpen("port") + OplinkNetconfUtility.xml("port-direction", direction) + OplinkNetconfUtility.xmlEmpty(KEY_PORTPROPERTY) + OplinkNetconfUtility.xmlClose("port") + OplinkNetconfUtility.xmlClose("ports") + OplinkNetconfUtility.xmlClose("open-optical-device");
    }

    private Long acquireTargetPower(PortNumber port, T component) {
        if (component instanceof OchSignal) {
            return this.acquireChannelAttenuation(port, (OchSignal)component);
        }
        log.debug("Get port{} target power...", (Object)port);
        return this.acquirePortPower(port, KEY_PORTTARPWR);
    }

    private Long acquireCurrentPower(PortNumber port, T component) {
        if (component instanceof OchSignal) {
            return this.acquireChannelPower(port, (OchSignal)component);
        }
        log.debug("Get port{} current power...", (Object)port);
        return this.acquirePortPower(port, KEY_PORTCURPWR);
    }

    private Long acquirePortPower(PortNumber port, String selection) {
        String reply = OplinkNetconfUtility.netconfGetConfig(this.handler(), this.getPortPowerFilter(port, selection));
        HierarchicalConfiguration info = OplinkNetconfUtility.configAt(reply, KEY_PORTS_PORT);
        if (info == null) {
            return null;
        }
        return (long)(info.getDouble(selection) * 100.0);
    }

    private Long acquireChannelAttenuation(PortNumber port, OchSignal channel) {
        log.debug("Get port{} channel{} attenuation...", (Object)port, (Object)channel.channelSpacing());
        String reply = OplinkNetconfUtility.netconfGetConfig(this.handler(), this.getChannelAttenuationFilter(port, channel));
        HierarchicalConfiguration info = OplinkNetconfUtility.configAt(reply, "connections");
        if (info == null) {
            return null;
        }
        return (long)(info.getDouble("attenuation") * 100.0);
    }

    private Long acquireChannelPower(PortNumber port, OchSignal channel) {
        log.debug("Get port{} channel{} power...", (Object)port, (Object)channel.channelSpacing());
        String reply = OplinkNetconfUtility.netconfGetConfig(this.handler(), this.getChannelPowerFilter(port, channel));
        HierarchicalConfiguration info = OplinkNetconfUtility.configAt(reply, OplinkNetconfUtility.KEY_DATA_CONNS);
        if (info == null) {
            return null;
        }
        return (long)(info.getDouble(KEY_CHPWR) * 100.0);
    }

    private boolean setPortTargetPower(PortNumber port, long power) {
        log.debug("Set port{} target power...", (Object)port);
        String cfg = OplinkNetconfUtility.xmlOpen(OplinkNetconfUtility.KEY_OPENOPTICALDEV_XMLNS) + OplinkNetconfUtility.xmlOpen("ports") + OplinkNetconfUtility.xml("port-id", Long.toString(port.toLong())) + OplinkNetconfUtility.xmlOpen("port") + OplinkNetconfUtility.xml(KEY_PORTTARPWR, Long.toString(power)) + OplinkNetconfUtility.xmlClose("port") + OplinkNetconfUtility.xmlClose("ports") + OplinkNetconfUtility.xmlClose("open-optical-device");
        return OplinkNetconfUtility.netconfEditConfig(this.handler(), "merge", cfg);
    }

    private boolean setChannelTargetPower(PortNumber port, OchSignal channel, long power) {
        log.debug("Set port{} channel{} attenuation.", (Object)port, (Object)channel.channelSpacing());
        FlowRuleService service = (FlowRuleService)this.handler().get(FlowRuleService.class);
        Iterable entries = service.getFlowEntries(this.data().deviceId());
        for (FlowEntry entry : entries) {
            OplinkCrossConnect crossConnect = OplinkOpticalUtility.fromFlowRule((HandlerBehaviour)this, (FlowRule)entry);
            if (!port.equals((Object)crossConnect.getInPort()) && !port.equals((Object)crossConnect.getOutPort()) || channel.spacingMultiplier() != crossConnect.getChannel()) continue;
            log.debug("Flow is found, modify the flow with attenuation.");
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(crossConnect.getOutPort()).extension((ExtensionTreatment)new OplinkAttenuation((int)power), this.data().deviceId()).build();
            service.applyFlowRules(new FlowRule[]{DefaultFlowRule.builder().forDevice(this.data().deviceId()).makePermanent().withSelector(entry.selector()).withTreatment(treatment).withPriority(entry.priority()).withCookie(entry.id().value()).build()});
            return true;
        }
        return false;
    }

    private Range<Long> getPowerRange(PortNumber port, String directionKey, String minKey, String maxKey) {
        String reply = OplinkNetconfUtility.netconfGetConfig(this.handler(), this.getPowerRangeFilter(port, directionKey));
        HierarchicalConfiguration info = OplinkNetconfUtility.configAt(reply, KEY_PORTS_PORT_PROPERTY);
        if (info == null) {
            return null;
        }
        long minPower = (long)(info.getDouble(minKey) * 100.0);
        long maxPower = (long)(info.getDouble(maxKey) * 100.0);
        return Range.closed((Comparable)Long.valueOf(minPower), (Comparable)Long.valueOf(maxPower));
    }

    private Range<Long> getTxPowerRange(PortNumber port, T component) {
        if (component instanceof Direction) {
            log.debug("Get target port{} power range...", (Object)port);
            return this.getPowerRange(port, KEY_PORTDIRECT_TX, KEY_PORTPWRCAPMINTX, KEY_PORTPWRCAPMAXTX);
        }
        log.debug("Get channel attenuation range...");
        return Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(2500L));
    }

    private Range<Long> getRxPowerRange(PortNumber port, T component) {
        log.debug("Get input port{} power range...", (Object)port);
        return this.getPowerRange(port, KEY_PORTDIRECT_RX, KEY_PORTPWRCAPMINRX, KEY_PORTPWRCAPMAXRX);
    }
}

