/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.oplink;

import java.util.Set;
import java.util.stream.IntStream;
import org.onlab.util.GuavaCollectors;
import org.onlab.util.Spectrum;
import org.onosproject.drivers.oplink.OplinkOpticalUtility;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.OchSignal;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.LambdaQuery;
import org.onosproject.net.driver.AbstractHandlerBehaviour;

public class OplinkOpticalLambdaQuery
extends AbstractHandlerBehaviour
implements LambdaQuery {
    private static final int MIN_CHANNEL = Math.round(OplinkOpticalUtility.START_CENTER_FREQ.subtract(Spectrum.CENTER_FREQUENCY).asHz() / OplinkOpticalUtility.CHANNEL_SPACING.frequency().asHz());
    private static final int MAX_CHANNEL = Math.round(OplinkOpticalUtility.STOP_CENTER_FREQ.subtract(Spectrum.CENTER_FREQUENCY).asHz() / OplinkOpticalUtility.CHANNEL_SPACING.frequency().asHz());

    public Set<OchSignal> queryLambdas(PortNumber port) {
        return (Set)IntStream.rangeClosed(MIN_CHANNEL, MAX_CHANNEL).mapToObj(x -> OchSignal.newDwdmSlot((ChannelSpacing)OplinkOpticalUtility.CHANNEL_SPACING, (int)x)).collect(GuavaCollectors.toImmutableSet());
    }
}

