/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.oplink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.onosproject.drivers.oplink.OplinkCrossConnect;
import org.onosproject.drivers.oplink.OplinkNetconfUtility;
import org.onosproject.drivers.oplink.OplinkOpticalUtility;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.net.PortNumber;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.HandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleProgrammable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplinkOpticalFlowRuleProgrammable
extends AbstractHandlerBehaviour
implements FlowRuleProgrammable {
    public static final String KEY_CHID = "wavelength-id";
    public static final String KEY_SRC = "source";
    public static final String KEY_DST = "destination";
    public static final String KEY_SRC_PORTID = String.format("%s.%s", "source", "port-id");
    public static final String KEY_SRC_CHID = String.format("%s.%s", "source", "wavelength-id");
    public static final String KEY_DST_PORTID = String.format("%s.%s", "destination", "port-id");
    private static final Logger log = LoggerFactory.getLogger(OplinkOpticalFlowRuleProgrammable.class);

    public Collection<FlowEntry> getFlowEntries() {
        return this.parseConnections();
    }

    public Collection<FlowRule> applyFlowRules(Collection<FlowRule> rules) {
        return this.applyConnections(rules);
    }

    public Collection<FlowRule> removeFlowRules(Collection<FlowRule> rules) {
        return this.removeConnections(rules);
    }

    private String getConnectionsFilter() {
        return OplinkNetconfUtility.xmlOpen(OplinkNetconfUtility.KEY_OPENOPTICALDEV_XMLNS) + OplinkNetconfUtility.xmlEmpty("connections") + OplinkNetconfUtility.xmlClose("open-optical-device");
    }

    private Collection<FlowEntry> parseConnections() {
        log.debug("Fetch connections...");
        String reply = OplinkNetconfUtility.netconfGetConfig(this.handler(), this.getConnectionsFilter());
        HierarchicalConfiguration cfg = XmlConfigParser.loadXmlString((String)reply);
        List subtrees = cfg.configurationsAt(OplinkNetconfUtility.KEY_DATA_CONNS);
        ArrayList<FlowEntry> list = new ArrayList<FlowEntry>();
        for (HierarchicalConfiguration connection : subtrees) {
            list.add((FlowEntry)new DefaultFlowEntry(this.parseConnection(connection), FlowEntry.FlowEntryState.ADDED));
        }
        return list;
    }

    private FlowRule parseConnection(HierarchicalConfiguration cfg) {
        return OplinkOpticalUtility.toFlowRule((HandlerBehaviour)this, PortNumber.portNumber((String)cfg.getString(KEY_SRC_PORTID)), PortNumber.portNumber((String)cfg.getString(KEY_DST_PORTID)), cfg.getInt(KEY_SRC_CHID));
    }

    private Collection<FlowRule> applyConnections(Collection<FlowRule> rules) {
        return rules.stream().filter(c -> this.applyConnection((FlowRule)c)).collect(Collectors.toList());
    }

    private boolean applyConnection(FlowRule rule) {
        log.debug("Applying connection {}", (Object)rule);
        OplinkCrossConnect crossConnect = OplinkOpticalUtility.fromFlowRule((HandlerBehaviour)this, rule);
        String connID = Integer.toString(crossConnect.getChannel());
        String cfg = OplinkNetconfUtility.xmlOpen(OplinkNetconfUtility.KEY_OPENOPTICALDEV_XMLNS) + OplinkNetconfUtility.xmlOpen("connections") + OplinkNetconfUtility.xml("connection-id", connID) + OplinkNetconfUtility.xmlOpen(KEY_SRC) + OplinkNetconfUtility.xml("port-id", crossConnect.getInPort().name()) + OplinkNetconfUtility.xml(KEY_CHID, connID) + OplinkNetconfUtility.xmlClose(KEY_SRC) + OplinkNetconfUtility.xmlOpen(KEY_DST) + OplinkNetconfUtility.xml("port-id", crossConnect.getOutPort().name()) + OplinkNetconfUtility.xmlClose(KEY_DST) + OplinkNetconfUtility.xml("attenuation", Integer.toString(crossConnect.getAttenuation())) + OplinkNetconfUtility.xmlClose("connections") + OplinkNetconfUtility.xmlClose("open-optical-device");
        return OplinkNetconfUtility.netconfEditConfig(this.handler(), "merge", cfg);
    }

    private Collection<FlowRule> removeConnections(Collection<FlowRule> rules) {
        return rules.stream().filter(c -> this.removeConnection((FlowRule)c)).collect(Collectors.toList());
    }

    private boolean removeConnection(FlowRule rule) {
        log.debug("Removing connection {}", (Object)rule);
        OplinkCrossConnect crossConnect = OplinkOpticalUtility.fromFlowRule((HandlerBehaviour)this, rule);
        String connID = Integer.toString(crossConnect.getChannel());
        String cfg = OplinkNetconfUtility.xmlOpen(OplinkNetconfUtility.KEY_OPENOPTICALDEV_XMLNS) + OplinkNetconfUtility.xmlOpen("connections") + OplinkNetconfUtility.xml("connection-id", connID) + OplinkNetconfUtility.xmlOpen(KEY_SRC) + OplinkNetconfUtility.xml("port-id", crossConnect.getInPort().name()) + OplinkNetconfUtility.xml(KEY_CHID, connID) + OplinkNetconfUtility.xmlClose(KEY_SRC) + OplinkNetconfUtility.xmlClose("connections") + OplinkNetconfUtility.xmlClose("open-optical-device");
        return OplinkNetconfUtility.netconfEditConfig(this.handler(), "remove", cfg);
    }
}

