/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.oplink;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.onlab.util.Frequency;
import org.onosproject.drivers.oplink.OplinkNetconfUtility;
import org.onosproject.drivers.oplink.OplinkOpticalUtility;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.optical.device.OmsPortHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplinkOpticalDeviceDescription
extends AbstractHandlerBehaviour
implements DeviceDescriptionDiscovery {
    private static final String KEY_PORTNAME = "port-name";
    private static final String PORT_DIRECTION = "direction";
    private static final Logger log = LoggerFactory.getLogger(OplinkOpticalDeviceDescription.class);

    public DeviceDescription discoverDeviceDetails() {
        log.debug("No description to be added for device");
        return null;
    }

    public List<PortDescription> discoverPortDetails() {
        log.debug("Port description to be added for device {}", (Object)this.data().deviceId());
        String reply = OplinkNetconfUtility.netconfGetConfig(this.handler(), this.getPortsFilter());
        List<PortDescription> descriptions = this.parsePorts(reply);
        return ImmutableList.copyOf(descriptions);
    }

    private String getPortsFilter() {
        return OplinkNetconfUtility.xmlOpen(OplinkNetconfUtility.KEY_OPENOPTICALDEV_XMLNS) + OplinkNetconfUtility.xmlEmpty("ports") + OplinkNetconfUtility.xmlClose("open-optical-device");
    }

    private List<PortDescription> parsePorts(String content) {
        HierarchicalConfiguration cfg = XmlConfigParser.loadXmlString((String)content);
        ArrayList portDescriptions = Lists.newArrayList();
        List subtrees = cfg.configurationsAt(OplinkNetconfUtility.KEY_DATA_PORTS);
        for (HierarchicalConfiguration portConfig : subtrees) {
            portDescriptions.add(this.parsePort(portConfig));
        }
        return portDescriptions;
    }

    private PortDescription parsePort(HierarchicalConfiguration cfg) {
        PortNumber portNumber = PortNumber.portNumber((long)cfg.getLong("port-id"));
        SubnodeConfiguration portInfo = cfg.configurationAt("port");
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("portName", portInfo.getString(KEY_PORTNAME)).set(PORT_DIRECTION, portInfo.getString("port-direction")).build();
        return OmsPortHelper.omsPortDescription((PortNumber)portNumber, (boolean)true, (Frequency)OplinkOpticalUtility.START_CENTER_FREQ, (Frequency)OplinkOpticalUtility.STOP_CENTER_FREQ, (Frequency)OplinkOpticalUtility.CHANNEL_SPACING.frequency(), (SparseAnnotations)annotations);
    }
}

